/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.geometry.Element;
import com.tssap.selena.layout.impl.geometry.GRectangle;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.geometry.Rectangle;

public final class Conflict {
    private static final int APoint = 1;
    private static final int AVerticalLine = 2;
    private static final int AHorizontalLine = 3;
    private static final int AnotherLine = 4;
    private static final int ARectangle = 5;
    private static final int AGRectangle = 6;
    private Object obj1 = null;
    private Object obj2 = null;
    private int kind1 = 0;
    private int kind2 = 0;
    private int myHashCode = 0;

    public Conflict() {
    }

    public Conflict(Element e1, Element e2) {
        this.obj1 = e1.getObject();
        this.obj2 = e2.getObject();
        this.kind1 = Conflict.calculateKind(e1);
        this.kind2 = Conflict.calculateKind(e2);
        this.myHashCode = this.obj1.hashCode() + this.obj2.hashCode() + this.kind1 + this.kind2;
    }

    public void set(Element e1, Element e2) {
        this.obj1 = e1.getObject();
        this.obj2 = e2.getObject();
        this.kind1 = Conflict.calculateKind(e1);
        this.kind2 = Conflict.calculateKind(e2);
        this.myHashCode = this.obj1.hashCode() + this.obj2.hashCode() + this.kind1 + this.kind2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Conflict) {
            Conflict conflict = (Conflict)obj;
            if (this.myHashCode == conflict.myHashCode && (this.obj1 == conflict.obj1 && this.obj2 == conflict.obj2 && this.kind1 == conflict.kind1 && this.kind2 == conflict.kind2 || this.obj2 == conflict.obj1 && this.obj1 == conflict.obj2 && this.kind2 == conflict.kind1 && this.kind1 == conflict.kind2)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private static int calculateKind(Element e) {
        if (e instanceof Point) {
            return 1;
        }
        if (e instanceof Line) {
            Line l = (Line)e;
            if (l.getX1() == l.getX2()) {
                return 2;
            }
            if (l.getY1() == l.getY2()) {
                return 3;
            }
            return 4;
        }
        if (e instanceof Rectangle) {
            return 5;
        }
        if (e instanceof GRectangle) {
            return 6;
        }
        throw new RuntimeException("CFLT001");
    }
}

