/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Edge;
import com.tssap.selena.layout.impl.Icon;
import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Optioner;
import com.tssap.selena.layout.impl.RightBound;
import com.tssap.selena.layout.impl.Service;
import com.tssap.selena.layout.impl.Vertex;
import com.tssap.selena.layout.impl.geometry.Line;
import com.tssap.selena.layout.impl.geometry.LinesManager;
import com.tssap.selena.layout.impl.geometry.Point;
import com.tssap.selena.layout.impl.geometry.Rectangle;
import java.util.Vector;

public final class ComponentsManager {
    private Optioner myOptioner;
    private Vector myVerticesArray = null;
    private Vector myEdgesArray = null;
    private Vertex[] myVertices = null;
    private Edge[] myEdges = null;
    private int componentCount;

    public ComponentsManager(Optioner optioner) {
        this.myOptioner = optioner;
    }

    public void start(Vector verticesArray, Vector edgesArray) {
        this.myVerticesArray = verticesArray;
        this.myEdgesArray = edgesArray;
    }

    public void countAdjacentLinks() {
        int i = 0;
        while (i < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i);
            v.myNumberOfLinks = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i2);
            ++edge.vertex1.myNumberOfLinks;
            if (edge.vertex1 != edge.vertex2) {
                ++edge.vertex2.myNumberOfLinks;
            }
            ++i2;
        }
    }

    public void selectComponents() {
        int i;
        int i2 = 0;
        while (i2 < this.myVerticesArray.size()) {
            ((Vertex)this.myVerticesArray.get((int)i2)).myComponent = i2;
            ++i2;
        }
        boolean b_Changes = true;
        while (b_Changes) {
            b_Changes = false;
            i = 0;
            while (i < this.myEdgesArray.size()) {
                Edge edge = (Edge)this.myEdgesArray.get(i);
                Vertex v1 = edge.vertex1;
                Vertex v2 = edge.vertex2;
                int comp1 = v1.myComponent;
                int comp2 = v2.myComponent;
                if (comp1 != comp2) {
                    if (comp1 < comp2) {
                        v2.myComponent = comp1;
                    } else {
                        v1.myComponent = comp2;
                    }
                    b_Changes = true;
                }
                ++i;
            }
        }
        this.componentCount = 0;
        i = 0;
        while (i < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i);
            if (v.myNumberOfLinks == 0) {
                v.myComponent = -1;
            } else {
                int comp = v.myComponent;
                if (comp >= this.componentCount) {
                    if (comp > this.componentCount) {
                        int j = i;
                        while (j < this.myVerticesArray.size()) {
                            Vertex v1 = (Vertex)this.myVerticesArray.get(j);
                            if (v1.myComponent == comp) {
                                v1.myComponent = this.componentCount;
                            }
                            ++j;
                        }
                    }
                    ++this.componentCount;
                }
            }
            ++i;
        }
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public void chooseComponent(int i_Component) {
        int Count = 0;
        int i = 0;
        while (i < this.myVerticesArray.size()) {
            if (((Vertex)this.myVerticesArray.get((int)i)).myComponent == i_Component) {
                ++Count;
            }
            ++i;
        }
        this.myVertices = new Vertex[Count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.myVerticesArray.size()) {
            Vertex v = (Vertex)this.myVerticesArray.get(i2);
            if (v.myComponent == i_Component) {
                this.myVertices[index] = v;
                v.index = index++;
            }
            ++i2;
        }
        Count = 0;
        int i3 = 0;
        while (i3 < this.myEdgesArray.size()) {
            if (((Edge)this.myEdgesArray.get((int)i3)).vertex1.myComponent == i_Component) {
                ++Count;
            }
            ++i3;
        }
        this.myEdges = new Edge[Count];
        index = 0;
        int i4 = 0;
        while (i4 < this.myEdgesArray.size()) {
            Edge edge = (Edge)this.myEdgesArray.get(i4);
            if (edge.vertex1.myComponent == i_Component) {
                this.myEdges[index++] = edge;
            }
            ++i4;
        }
    }

    public Vertex[] getVertices() {
        return this.myVertices;
    }

    public Edge[] getEdges() {
        return this.myEdges;
    }

    public void buildLinksList() {
        int i = 0;
        while (i < this.myVertices.length) {
            this.myVertices[i].myLinks = new Link[this.myVertices[i].myNumberOfLinks];
            this.myVertices[i].tempInt = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.myEdges.length) {
            Edge edge = this.myEdges[i2];
            Vertex vertex1 = edge.vertex1;
            Vertex vertex2 = edge.vertex2;
            Link newLink = new Link();
            vertex1.myLinks[vertex1.tempInt++] = newLink;
            newLink.myVertex = vertex2;
            newLink.myEdge = edge;
            int n = newLink.iDirected = vertex1 != vertex2 ? 1 : 0;
            if (vertex1 != vertex2) {
                newLink = new Link();
                vertex2.myLinks[vertex2.tempInt++] = newLink;
                newLink.myVertex = vertex1;
                newLink.myEdge = edge;
                newLink.iDirected = -1;
            }
            ++i2;
        }
    }

    public Rectangle calculateComponentBoundingRect() {
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            left = Math.min(left, v.getLeft());
            right = Math.max(right, v.getRight());
            top = Math.min(top, v.getTop());
            bottom = Math.max(bottom, v.getBottom());
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            int i_Point = 0;
            while (i_Point < edge.getPointCount()) {
                Point p = edge.getPointAt(i_Point);
                left = Math.min(left, p.x);
                right = Math.max(right, p.x);
                top = Math.min(top, p.y);
                bottom = Math.max(bottom, p.y);
                ++i_Point;
            }
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                Icon icon = edge.getIconAt(i_Icon);
                left = Math.min(left, icon.getLeft());
                right = Math.max(right, icon.getRight());
                top = Math.min(top, icon.getTop());
                bottom = Math.max(bottom, icon.getBottom());
                ++i_Icon;
            }
            ++i_Edge;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public void calculateNewRightBound(RightBound old) {
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            old.add(this.myVertices[i_Vertex]);
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            old.add(edge);
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                old.add(edge.getIconAt(i_Icon));
                ++i_Icon;
            }
            ++i_Edge;
        }
    }

    public int adjustComponent(RightBound startX, int whereTo) {
        int shift = Integer.MIN_VALUE;
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            shift = Math.max(shift, startX.calculateShift(this.myVertices[i_Vertex]));
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge edge = this.myEdges[i_Edge];
            shift = Math.max(shift, startX.calculateShift(edge));
            int i_Icon = 0;
            while (i_Icon < edge.getIconCount()) {
                shift = Math.max(shift, startX.calculateShift(edge.getIconAt(i_Icon)));
                ++i_Icon;
            }
            ++i_Edge;
        }
        if (whereTo > 0 && shift < 0) {
            return shift;
        }
        if (whereTo < 0 && shift > 0) {
            return shift;
        }
        if (this.myOptioner.pagingFlag) {
            shift = (int)Math.ceil((float)shift / (float)this.myOptioner.pageWidth) * this.myOptioner.pageWidth;
        }
        if (shift == 0) {
            return 0;
        }
        this.shiftComponent(shift, 0);
        return shift;
    }

    public void shiftComponent(int shiftx, int shifty) {
        Service.shift(this.myVertices, this.myEdges, shiftx, shifty);
    }

    public void transponateComponent() {
        int startY;
        int pageH;
        Service.transponate(this.myVertices, this.myEdges);
        int pageW = this.myOptioner.pageWidth;
        this.myOptioner.pageWidth = pageH = this.myOptioner.pageHeight;
        this.myOptioner.pageHeight = pageW;
        int startX = this.myOptioner.startX;
        this.myOptioner.startX = startY = this.myOptioner.startY;
        this.myOptioner.startY = startX;
    }

    public boolean isCorrectWith(LinesManager linesManager) {
        int i_Vertex = 0;
        while (i_Vertex < this.myVertices.length) {
            Vertex v = this.myVertices[i_Vertex];
            if (!linesManager.isCorrect(v)) {
                return false;
            }
            ++i_Vertex;
        }
        int i_Edge = 0;
        while (i_Edge < this.myEdges.length) {
            Edge e = this.myEdges[i_Edge];
            int n = e.getPointCount();
            int i_Point = 0;
            while (i_Point < n - 1) {
                Point p1 = e.getPointAt(i_Point);
                Point p2 = e.getPointAt(i_Point + 1);
                if (i_Point != 0 && !linesManager.isCorrect(p1)) {
                    return false;
                }
                Line l = new Line(p1.x, p1.y, p2.x, p2.y, e);
                if (!linesManager.isCorrect(l)) {
                    return false;
                }
                ++i_Point;
            }
            int i_Icon = 0;
            while (i_Icon < e.getIconCount()) {
                Icon i = e.getIconAt(i_Icon);
                if (!linesManager.isCorrect(i)) {
                    return false;
                }
                ++i_Icon;
            }
            ++i_Edge;
        }
        return true;
    }
}

