/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.impl;

import com.tssap.selena.layout.impl.Link;
import com.tssap.selena.layout.impl.Vertex;

public final class Bary {
    private int up;
    private int down;
    private int full;

    public void calculateFor(Vertex v, int d) {
        this.full = -1;
        this.down = -1;
        this.up = -1;
        int baryCountUp = 0;
        int baryCountDown = 0;
        int totalLineUp = 0;
        int totalLineDown = 0;
        int i_Level = v.level;
        Link[] links = v.myLinks;
        int i_Link = 0;
        while (i_Link < links.length) {
            Vertex vertex = links[i_Link].myVertex;
            int level = vertex.level;
            if (d >= 0 && level == i_Level + 1) {
                baryCountDown += vertex.absPos;
                ++totalLineDown;
            } else if (d <= 0 && level == i_Level - 1) {
                baryCountUp += vertex.absPos;
                ++totalLineUp;
            }
            ++i_Link;
        }
        if (totalLineUp != 0) {
            this.up = 1000 * baryCountUp / totalLineUp;
        }
        if (totalLineDown != 0) {
            this.down = 1000 * baryCountDown / totalLineDown;
        }
        if (totalLineUp + totalLineDown != 0) {
            this.full = 1000 * (baryCountUp + baryCountDown) / (totalLineUp + totalLineDown);
        }
    }

    public boolean equalTo(Bary b) {
        if (this.up < 0 || b.up < 0) {
            return this.down < 0 || b.down < 0 || this.down == b.down;
        }
        if (this.down < 0 || b.down < 0) {
            return this.up == b.up;
        }
        return this.full == b.full;
    }

    public boolean lessThan(Bary b) {
        if (this.up < 0 || b.up < 0) {
            return this.down >= 0 && b.down >= 0 && this.down < b.down;
        }
        if (this.down < 0 || b.down < 0) {
            return this.up < b.up;
        }
        return this.full < b.full;
    }

    public boolean greaterThan(Bary b) {
        return b.lessThan(this);
    }
}

