/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.layout.gde;

import com.tssap.selena.gde.IDiagramLayoutManager;
import com.tssap.selena.gde.internal.DiagramLink;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.gde.internal.editparts.LinkEditPart;
import com.tssap.selena.gde.viewmap.AlignType;
import com.tssap.selena.gde.viewmap.ILinkDecoration;
import com.tssap.selena.layout.LayoutFactory;
import com.tssap.selena.layout.LayoutIcon;
import com.tssap.selena.layout.LayoutLink;
import com.tssap.selena.layout.LayoutNode;
import com.tssap.selena.layout.LayoutOptions;
import com.tssap.selena.layout.LayoutPoint;
import com.tssap.selena.layout.NonlayoutableConnection;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.diagram.IUpdatableNode;
import com.tssap.selena.model.util.ShortCommand;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DiagramLayouter
implements IDiagramLayoutManager {
    private HashMap myLayoutedNodesMap;
    private HashSet myRawLinks;
    private ArrayList myNodes;
    private ArrayList myLinks;
    private Collection myReshaped;
    private static final Dimension MINIMUM_SIZE_FOR_TOP_LEVEL_NODES = new Dimension(50, 50);
    private static final Dimension MINIMUM_SIZE_FOR_INNER_NODES = new Dimension(50, 30);

    public void fullLayout(IDiagram diagram, boolean forPrinting, Dimension gridDimension) {
        this.fullLayout(diagram, false, forPrinting, gridDimension);
    }

    public void partialLayout(IDiagram diagram, Collection selectedElements, Collection reshapedElements) {
        this.layout(3, diagram, selectedElements, reshapedElements, false, false, null);
    }

    public void selectedLayout(IDiagram diagram, Collection selectedElements) {
    }

    private void fullLayout(IDiagram diagram, boolean optimize, boolean forPrinting, Dimension gridDimension) {
        this.layout(1, diagram, null, null, optimize, forPrinting, gridDimension);
    }

    private void layout(final int type, final IDiagram diagram, final Collection selected, final Collection reshaped, final boolean optimize, final boolean forPrinting, final Dimension gridDimension) {
        long startTime = System.currentTimeMillis();
        ModelAccess.runCommand((Runnable)new ShortCommand(){

            public void run() {
                DiagramLayouter.this.init();
                DiagramLayouter.this.doLayout(type, diagram, selected, reshaped, optimize, forPrinting, gridDimension);
                DiagramLayouter.this.dispose();
                long l = System.currentTimeMillis();
            }
        });
    }

    private void init() {
        this.myLayoutedNodesMap = new HashMap();
        this.myRawLinks = new HashSet();
        this.myNodes = new ArrayList();
        this.myLinks = new ArrayList();
    }

    private void dispose() {
        this.myLayoutedNodesMap = null;
        this.myRawLinks = null;
        this.myNodes = null;
        this.myLinks = null;
        this.myReshaped = null;
    }

    private void doLayout(int type, IDiagram diagram, Collection selected, Collection reshaped, boolean optimize, boolean forPrinting, Dimension gridDimension) {
        if (selected == null) {
            selected = new HashSet();
        }
        if (reshaped == null) {
            reshaped = new HashSet();
        }
        this.myReshaped = reshaped;
        this.processContents((IUpdatableNode)diagram, optimize, selected, reshaped);
        this.myRawLinks.addAll(diagram.links());
        this.createLinks(selected);
        if (this.myRawLinks.size() == 0 && this.myNodes.size() == 0) {
            return;
        }
        LayoutOptions options = LayoutFactory.getInstance().createOptions(type, 1);
        options.setLayoutQuality(3);
        options.setVerticalDirection(1);
        options.setNodeJustification(4);
        if (forPrinting) {
            options.setPrintGrid(gridDimension.width, gridDimension.height);
        }
        LayoutFactory.getInstance().createLayouter(options).doLayout(this.myNodes, this.myLinks);
        this.proccessResults(false);
    }

    private void proccessResults(boolean incremental) {
        ListIterator nodesEnum = ((AbstractList)this.myNodes).listIterator(this.myNodes.size());
        while (nodesEnum.hasPrevious()) {
            LayoutNode layoutNode = (LayoutNode)nodesEnum.previous();
            DiagramNode node = (DiagramNode)layoutNode.getUserObject();
            if (incremental && !layoutNode.isSelected()) continue;
            LayoutNode containingNode = layoutNode.getContainingNode();
            if (containingNode != null) {
                Point gap = DiagramLayouter.getGap(layoutNode);
                layoutNode.setX(layoutNode.getX() - containingNode.getX() - gap.x);
                layoutNode.setY(layoutNode.getY() - containingNode.getY() - gap.y);
            }
            Rectangle rect = DiagramLayouter.rectangle(layoutNode);
            node.getNodeEditPart().setBounds(rect);
        }
        Iterator linksEnum = ((AbstractList)this.myLinks).iterator();
        while (linksEnum.hasNext()) {
            LayoutLink layoutLink = (LayoutLink)linksEnum.next();
            DiagramLink link = (DiagramLink)layoutLink.getUserObject();
            if (incremental && !layoutLink.isSelected()) continue;
            Point[] bends = new Point[layoutLink.getPointCount() - 2];
            int i = 0;
            while (i < bends.length) {
                bends[i] = DiagramLayouter.point(layoutLink.getPoint(i + 1));
                ++i;
            }
            link.getLinkEditPart().setBendpointLocations(bends);
            Point startPoint = DiagramLayouter.point(layoutLink.getPoint(0));
            Point endPoint = DiagramLayouter.point(layoutLink.getPoint(layoutLink.getPointCount() - 1));
            link.getLinkEditPart().setSourcePoint(startPoint);
            link.getLinkEditPart().setTargetPoint(endPoint);
            this.myReshaped.add(link);
            this.reshapeIconsOnLink(layoutLink, true);
        }
    }

    private static Point getGap(LayoutNode node) {
        Point gap = new Point();
        if (node == null || node.getContainingNode() == null) {
            return gap;
        }
        DiagramNode diagramNode = (DiagramNode)node.getUserObject();
        if ((diagramNode = (DiagramNode)diagramNode.getParentNode()) == null) {
            return gap;
        }
        gap.y = diagramNode.getNodeEditPart().getContentPane().getBounds().y - diagramNode.getNodeEditPart().getOriginalFigure().getBounds().y;
        gap.x = diagramNode.getNodeEditPart().getContentPane().getBounds().x - diagramNode.getNodeEditPart().getOriginalFigure().getBounds().x;
        return gap;
    }

    private static Point point(LayoutPoint layoutPoint) {
        return new Point(layoutPoint.getX(), layoutPoint.getY());
    }

    private static Rectangle rectangle(LayoutNode layoutNode) {
        return new Rectangle(layoutNode.getX(), layoutNode.getY(), layoutNode.getWidth(), layoutNode.getHeight());
    }

    private void processContents(IUpdatableNode input, boolean optimize, Collection selected, Collection reshaped) {
        Collection childNodes = input.getChildNodes();
        Iterator it = childNodes.iterator();
        while (it.hasNext()) {
            DiagramNode node = (DiagramNode)it.next();
            if (node.getNodeEditPart() == null || node.getNodeEditPart().isInner()) continue;
            Rectangle rect = node.getNodeEditPart().getBounds();
            LayoutNode layoutNode = LayoutFactory.getInstance().createNode();
            layoutNode.setUserObject(node);
            layoutNode.setX(rect.x);
            layoutNode.setY(rect.y);
            layoutNode.setWidth(rect.width);
            layoutNode.setHeight(rect.height);
            LayoutNode containingNode = (LayoutNode)this.myLayoutedNodesMap.get(input);
            if (containingNode != null) {
                layoutNode.setContainingNode(containingNode);
                Point gap = DiagramLayouter.getGap(layoutNode);
                layoutNode.setX(rect.x + containingNode.getX() + gap.x);
                layoutNode.setY(rect.y + containingNode.getY() + gap.y);
            }
            if (selected != null && selected.contains(node)) {
                layoutNode.setSelected(true);
            }
            if (selected != null && reshaped.contains(node)) {
                layoutNode.setReshaped(true);
            }
            this.myNodes.add(layoutNode);
            this.myLayoutedNodesMap.put(node, layoutNode);
            this.processContents((IUpdatableNode)node, optimize, selected, reshaped);
        }
    }

    private Dimension getPreferredSize(DiagramNode node) {
        return node.getEditPart().getFigure().getPreferredSize();
    }

    private void createLinks(Collection elementsToLayout) {
        boolean count = false;
        if (elementsToLayout == null) {
            elementsToLayout = new ArrayList();
        }
        Iterator it = this.myRawLinks.iterator();
        while (it.hasNext()) {
            DiagramLink link = (DiagramLink)it.next();
            if (link.getLinkEditPart().getOriginalFigure() instanceof NonlayoutableConnection) continue;
            LayoutNode fromNode = (LayoutNode)this.myLayoutedNodesMap.get(link.getSourceNode());
            LayoutNode toNode = (LayoutNode)this.myLayoutedNodesMap.get(link.getTargetElement());
            if (fromNode == null || toNode == null) continue;
            LayoutLink layoutLink = LayoutFactory.getInstance().createLink();
            layoutLink.setFromNode(fromNode);
            layoutLink.setToNode(toNode);
            layoutLink.setUserObject(link);
            if (elementsToLayout != null && elementsToLayout.contains(link) || fromNode.isReshaped() || toNode.isReshaped()) {
                layoutLink.setSelected(true);
                fromNode.setReshaped(true);
                toNode.setReshaped(true);
            }
            this.addIconsForLayout(layoutLink, link);
            boolean isVerticalLink = false;
            boolean isReversedLink = false;
            boolean isMergedLink = false;
            if (link.getContent() instanceof Reference) {
                Entity entity = ((Reference)link.getContent()).getEntity();
                String metaclass = entity.getPropertyValue("$metaclass");
                isVerticalLink = "Generalization Link".equals(metaclass) || "Implementation Link".equals(metaclass);
                isMergedLink = "Generalization Link".equals(metaclass) || "Implementation Link".equals(metaclass);
                boolean bl = isReversedLink = "Transition".equals(metaclass) || "Object Flow".equals(metaclass);
            }
            if (isVerticalLink) {
                layoutLink.setDirected(1);
            }
            if (isReversedLink) {
                layoutLink.setDirected(2);
            }
            if (isMergedLink) {
                layoutLink.setGroupId(1);
            }
            LinkEditPart linkEditPart = (LinkEditPart)link.getEditPart();
            Connection figure = (Connection)linkEditPart.getFigure();
            ArrayList<Point> draw2dPoints = new ArrayList<Point>();
            if (linkEditPart.getSourcePoint() != null) {
                draw2dPoints.add(linkEditPart.getSourcePoint());
            }
            Point[] bendpointLocations = linkEditPart.getBendpointLocations();
            int i = 0;
            while (i < bendpointLocations.length) {
                Point bendpoint = new Point(bendpointLocations[i]);
                draw2dPoints.add(bendpoint);
                ++i;
            }
            if (linkEditPart.getTargetPoint() != null) {
                draw2dPoints.add(linkEditPart.getTargetPoint());
            }
            Iterator itr = draw2dPoints.iterator();
            while (itr.hasNext()) {
                Point p = (Point)itr.next();
                LayoutPoint layoutPoint = LayoutFactory.getInstance().createPoint(p.x, p.y);
                layoutLink.addPoint(layoutPoint);
            }
            this.myLinks.add(layoutLink);
        }
    }

    private void addIconsForLayout(LayoutLink layoutLink, DiagramLink diagramLink) {
        LinkEditPart editPart = diagramLink.getLinkEditPart();
        ILinkDecoration[] decorations = editPart.getDecorations();
        LayoutFactory factory = LayoutFactory.getInstance();
        boolean srcDecorations = false;
        boolean dstDecorations = false;
        int di = 0;
        while (di < decorations.length) {
            String text;
            ILinkDecoration decoration = decorations[di];
            if (!(decoration instanceof Label) || (text = ((Label)decoration).getText()) != null && !"".equals(text.trim())) {
                LayoutIcon icon = factory.createIcon();
                icon.setUserObject(decoration);
                icon.setWidth(decoration.getPreferredSize().width);
                icon.setHeight(decoration.getPreferredSize().height);
                icon.setSin(0.0f);
                icon.setCos(1.0f);
                icon.setDirected(false);
                icon.setGrouped(false);
                icon.setSelected(true);
                AlignType xAlign = decoration.getLayoutType().getXAlign();
                if (xAlign == AlignType.LEFT) {
                    icon.setHorPos(1);
                    srcDecorations = true;
                } else if (xAlign == AlignType.CENTER) {
                    icon.setHorPos(3);
                } else if (xAlign == AlignType.RIGHT) {
                    icon.setHorPos(2);
                    dstDecorations = true;
                }
                AlignType yAlign = decoration.getLayoutType().getYAlign();
                if (yAlign == AlignType.ON) {
                    icon.setVertPos(15);
                } else if (yAlign == AlignType.ABOVE_LEFT) {
                    icon.setVertPos(10);
                } else if (yAlign == AlignType.UNDER_LEFT) {
                    icon.setVertPos(11);
                } else if (yAlign == AlignType.ABOVE_RIGHT) {
                    icon.setVertPos(12);
                } else if (yAlign == AlignType.UNDER_RIGHT) {
                    icon.setVertPos(13);
                } else if (yAlign == AlignType.ASIDE) {
                    icon.setVertPos(14);
                }
                layoutLink.addIcon(icon);
            }
            ++di;
        }
        if (layoutLink.getIconCount() == 0) {
            return;
        }
        LayoutIcon source = this.createArrowIcon(diagramLink.getLinkEditPart().getSourceDecoration(), 1);
        LayoutIcon target = this.createArrowIcon(diagramLink.getLinkEditPart().getTargetDecoration(), 2);
        if (source != null && srcDecorations) {
            layoutLink.addIcon(source);
        }
        if (target != null && dstDecorations) {
            layoutLink.addIcon(target);
        }
    }

    private LayoutIcon createArrowIcon(Dimension size, int pos) {
        if (size == null) {
            return null;
        }
        LayoutIcon icon = LayoutFactory.getInstance().createIcon();
        icon.setVertPos(15);
        icon.setHorPos(pos);
        icon.setWidth(size.width);
        icon.setHeight(size.height);
        return icon;
    }

    private void reshapeIconsOnLink(LayoutLink layoutLink, boolean toMoveUnselectedIcons) {
        int[][] sizesMap = new int[3][6];
        int i = 0;
        while (i < layoutLink.getIconCount()) {
            ILinkDecoration decoration;
            LayoutIcon icon = layoutLink.getIcon(i);
            if (icon != null && (decoration = (ILinkDecoration)icon.getUserObject()) != null) {
                decoration.setBounds(new Rectangle(icon.getX(), icon.getY(), icon.getWidth(), icon.getHeight()));
            }
            ++i;
        }
    }
}

