/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.xml;

import com.sap.sdm.util.classloaders.ClassLoaderConstants;
import com.sap.sdm.util.classloaders.ClassLoaderManager;
import com.sap.sdm.util.classloaders.ClassLoadingSystemFactory;
import com.sap.sdm.util.classloaders.ComponentId;
import com.sap.sdm.util.classloaders.SDMClassLoaderException;
import com.sap.sdm.util.dbaccess.AbstractSelectionReader;
import com.sap.sdm.xml.AbstractXMLElementBuilder;
import com.sap.sdm.xml.XMLElementFactory;
import com.sap.sdm.xml.XMLException;

public final class XMLParserAccessFactory {
    private static final ComponentId COMP_UTIL_XML = ClassLoadingSystemFactory.createComponentId("com.sap.sdm.xml.UTIL_XML");
    private static final String PROPFILE_UTIL_XML = "com/sap/sdm/xml/resources/util_xml.properties";
    private static final String BUILDER_CLASS_NAME_UTIL_XML = "com.sap.sdm.xml.extern.XMLElementBuilder";
    private static final String SELECTION_READER_CLASS_NAME_UTIL_XML = "com.sap.sdm.xml.extern.dbaccess.SelectionReader";
    private static boolean isClassLoadingRegistered = false;

    public static final AbstractSelectionReader createSelectionReader() throws XMLException {
        AbstractSelectionReader reader = null;
        try {
            ComponentId id = COMP_UTIL_XML;
            XMLParserAccessFactory.registerClassLoading();
            ClassLoader loader = ClassLoaderManager.getInstance().getClassLoader(id);
            Class<?> cls = loader.loadClass(SELECTION_READER_CLASS_NAME_UTIL_XML);
            ClassLoaderManager.getInstance().pushContextClassLoader(id);
            try {
                reader = (AbstractSelectionReader)cls.newInstance();
                Object var5_5 = null;
                ClassLoaderManager.getInstance().popContextClassLoader();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ClassLoaderManager.getInstance().popContextClassLoader();
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new XMLException("Cannot create reader for select file.", e);
        }
        return reader;
    }

    static final AbstractXMLElementBuilder createXMLElementBuilder(XMLElementFactory factory) throws XMLException {
        AbstractXMLElementBuilder builder = null;
        try {
            ComponentId id = COMP_UTIL_XML;
            XMLParserAccessFactory.registerClassLoading();
            ClassLoader loader = ClassLoaderManager.getInstance().getClassLoader(id);
            Class<?> cls = loader.loadClass(BUILDER_CLASS_NAME_UTIL_XML);
            ClassLoaderManager.getInstance().pushContextClassLoader(id);
            try {
                builder = (AbstractXMLElementBuilder)cls.newInstance();
                Object var6_6 = null;
                ClassLoaderManager.getInstance().popContextClassLoader();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ClassLoaderManager.getInstance().popContextClassLoader();
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new XMLException("Cannot create an instance of XML parser.", e);
        }
        builder.setFactory(factory);
        return builder;
    }

    private static void registerClassLoading() throws SDMClassLoaderException {
        if (!isClassLoadingRegistered) {
            ClassLoadingSystemFactory.getInstance().registerConfiguration(COMP_UTIL_XML, ClassLoaderConstants.COMP_COMMON_BOOTSTRAP, PROPFILE_UTIL_XML, null, null);
            isClassLoadingRegistered = true;
        }
    }
}

