/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.xml;

import com.sap.sdm.xml.XMLElementFactory;
import com.sap.sdm.xml.XMLElementIF;
import com.sap.sdm.xml.XMLReconstructionException;

public abstract class AbstractXMLizer {
    private String xmlName = null;
    private XMLElementFactory factory = XMLElementFactory.newInstance();

    protected AbstractXMLizer(String xmlName) {
        this.xmlName = xmlName;
    }

    public final boolean hasName(XMLElementIF xmlElement, String name) {
        return !this.isNullElement(xmlElement) && !this.hasNoName(xmlElement) && !this.hasDifferentName(xmlElement, name);
    }

    public final boolean acceptsAsRootElem(XMLElementIF xmlElement) {
        return this.hasName(xmlElement, this.getXMLName());
    }

    public final String getXMLName() {
        return this.xmlName;
    }

    protected void checkForCorrectElem(String elementName, XMLElementIF xmlElement) throws XMLReconstructionException {
        if (this.isNullElement(xmlElement)) {
            throw new XMLReconstructionException("Element " + elementName + " expected, null element received.");
        }
        if (this.hasNoName(xmlElement)) {
            throw new XMLReconstructionException("Element " + elementName + " expected, element without name received.");
        }
        if (this.hasDifferentName(xmlElement, elementName)) {
            throw new XMLReconstructionException("Element " + elementName + " expected, element " + xmlElement.getName() + " detected.");
        }
    }

    protected void checkForCorrectRootElem(XMLElementIF xmlElement) throws XMLReconstructionException {
        if (this.acceptsAsRootElem(xmlElement)) {
            return;
        }
        this.checkForCorrectElem(this.getXMLName(), xmlElement);
    }

    protected String getContentFromElem(String expectedName, XMLElementIF xmlElement) throws XMLReconstructionException {
        this.checkForCorrectElem(expectedName, xmlElement);
        return xmlElement.getContent();
    }

    protected String getContentFromOptElem(String expectedName, XMLElementIF xmlElement) {
        if (this.hasName(xmlElement, expectedName)) {
            return xmlElement.getContent();
        }
        return null;
    }

    protected int getContentFromElemAsInt(String expectedName, XMLElementIF xmlElement) throws XMLReconstructionException {
        String contentAsString = this.getContentFromElem(expectedName, xmlElement);
        try {
            return Integer.parseInt(contentAsString);
        }
        catch (NumberFormatException e) {
            throw new XMLReconstructionException("Cannot convert content \"" + contentAsString + "\" from XML element " + expectedName + " to an integer value.");
        }
    }

    protected Integer getContentFromOptElemAsInteger(String expectedName, XMLElementIF xmlElement) throws XMLReconstructionException {
        if (this.hasName(xmlElement, expectedName)) {
            String contentAsString = xmlElement.getContent();
            try {
                return new Integer(contentAsString);
            }
            catch (NumberFormatException e) {
                throw new XMLReconstructionException("Cannot convert content \"" + contentAsString + "\" from XML element " + expectedName + " to an integer value.");
            }
        }
        return null;
    }

    protected boolean getContentFromElemAsBoolean(String expectedName, XMLElementIF xmlElement) throws XMLReconstructionException {
        String contentAsString = this.getContentFromElem(expectedName, xmlElement);
        if ("true".equalsIgnoreCase(contentAsString)) {
            return true;
        }
        if ("false".equalsIgnoreCase(contentAsString)) {
            return false;
        }
        throw new XMLReconstructionException("Cannot convert content \"" + contentAsString + "\" from XML element " + expectedName + " to a boolean value.");
    }

    protected Boolean getContentFromOptElemAsBoolean(String expectedName, XMLElementIF xmlElement) throws XMLReconstructionException {
        if (this.hasName(xmlElement, expectedName)) {
            String contentAsString = xmlElement.getContent();
            if ("true".equalsIgnoreCase(contentAsString)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(contentAsString)) {
                return Boolean.FALSE;
            }
            throw new XMLReconstructionException("Cannot convert content \"" + contentAsString + "\" from XML element " + expectedName + " to a boolean value.");
        }
        return null;
    }

    protected XMLElementIF createRootElem() {
        return this.factory.createXMLElementWithName(this.getXMLName());
    }

    protected XMLElementIF createElemWithName(String name) {
        return this.factory.createXMLElementWithName(name);
    }

    protected XMLElementIF createElemWithNameAndContent(String name, String content) {
        return this.factory.createXMLElementWithNameAndContent(name, content);
    }

    protected XMLElementIF createElemWithNameAndContent(String name, boolean content) {
        return this.factory.createXMLElementWithNameAndContent(name, String.valueOf(content));
    }

    protected XMLElementIF createElemWithNameAndContent(String name, int content) {
        return this.factory.createXMLElementWithNameAndContent(name, String.valueOf(content));
    }

    protected XMLElementIF createOptElemWithNameAndContent(String name, String content) {
        if (content != null) {
            return this.createElemWithNameAndContent(name, content);
        }
        return null;
    }

    private boolean isNullElement(XMLElementIF xmlElement) {
        return xmlElement == null;
    }

    private boolean hasNoName(XMLElementIF xmlElement) {
        return xmlElement.getName() == null || xmlElement.getName().trim().equals("");
    }

    private boolean hasDifferentName(XMLElementIF xmlElement, String elementName) {
        return !xmlElement.getName().equals(elementName);
    }
}

