/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.xml;

public final class XMLFilter {
    public static final String AMP = "&amp;";
    public static final String GT = "&gt;";
    public static final String LT = "&lt;";
    public static final String QUOT = "&quot;";
    public static final String BEGIN_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";

    public static String filterOutput(String xml) {
        StringBuffer filtered = new StringBuffer((int)((double)xml.length() * 1.1));
        int i = 0;
        while (i < xml.length()) {
            char c = xml.charAt(i);
            switch (c) {
                case '<': {
                    filtered.append(LT);
                    break;
                }
                case '>': {
                    filtered.append(GT);
                    break;
                }
                case '\"': {
                    filtered.append(QUOT);
                    break;
                }
                case '&': {
                    filtered.append(AMP);
                    break;
                }
                case '\u00a9': {
                    filtered.append("(c)");
                    break;
                }
                case '\u00c4': {
                    filtered.append("A");
                    break;
                }
                case '\u00e4': {
                    filtered.append("a");
                    break;
                }
                case '\u00d6': {
                    filtered.append("O");
                    break;
                }
                case '\u00f6': {
                    filtered.append("o");
                    break;
                }
                case '\u00dc': {
                    filtered.append("U");
                    break;
                }
                case '\u00fc': {
                    filtered.append("u");
                    break;
                }
                default: {
                    filtered.append(c);
                }
            }
            ++i;
        }
        return filtered.toString();
    }

    public static String checkAndFilterOutput(String text) {
        if (!text.startsWith(BEGIN_CDATA) || !text.endsWith(END_CDATA)) {
            return XMLFilter.filterOutput(text);
        }
        return text;
    }

    public static String filterInput(String text) {
        StringBuffer filtered = new StringBuffer((int)((double)text.length() * 0.9));
        int counter = 0;
        while (counter < text.length()) {
            char c = text.charAt(counter);
            if (c == '&') {
                if (text.regionMatches(true, counter, AMP, 0, AMP.length())) {
                    filtered.append('&');
                    counter += AMP.length();
                    continue;
                }
                if (text.regionMatches(true, counter, LT, 0, LT.length())) {
                    filtered.append('<');
                    counter += LT.length();
                    continue;
                }
                if (text.regionMatches(true, counter, GT, 0, GT.length())) {
                    filtered.append('>');
                    counter += GT.length();
                    continue;
                }
                if (text.regionMatches(true, counter, QUOT, 0, QUOT.length())) {
                    filtered.append('\"');
                    counter += QUOT.length();
                    continue;
                }
                filtered.append('&');
                ++counter;
                continue;
            }
            filtered.append(c);
            ++counter;
        }
        return filtered.toString();
    }

    public static String checkAndFilterInput(String text) {
        if (text.startsWith(BEGIN_CDATA) && text.endsWith(END_CDATA)) {
            return text.substring(BEGIN_CDATA.length(), text.length() - END_CDATA.length());
        }
        return XMLFilter.filterInput(text);
    }
}

