/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.version;

import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.version.Version;
import com.sap.sdm.util.version.VersionImpl;
import java.math.BigInteger;
import java.util.StringTokenizer;

public final class VersionFactory {
    private static final Logger log = Logger.getLogger();
    static /* synthetic */ Class class$com$sap$sdm$util$version$VersionFactory;

    private VersionFactory() {
    }

    public static boolean isValidVersionString(String versionString) {
        if (versionString == null) {
            return false;
        }
        String[] stringTokens = VersionFactory.getStringTokens(versionString);
        if (stringTokens.length == 0) {
            return false;
        }
        int i = 0;
        while (i < stringTokens.length) {
            BigInteger bigI;
            try {
                bigI = new BigInteger(stringTokens[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (bigI.compareTo(BigInteger.ZERO) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Version createVersion(String versionString) {
        VersionFactory.paramCheck("createVersion", versionString);
        if (!VersionFactory.isValidVersionString(versionString)) {
            throw new IllegalArgumentException("Invalid version string " + versionString);
        }
        return new VersionImpl(VersionFactory.getStringTokens(versionString));
    }

    static boolean isValidSequence(BigInteger[] bigInts) {
        if (bigInts == null || bigInts.length == 0) {
            return false;
        }
        int i = 0;
        while (i < bigInts.length) {
            if (bigInts[i].compareTo(BigInteger.ZERO) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Version createFromBigInts(BigInteger[] bigInts) {
        VersionFactory.paramCheck("createFromBigInts", bigInts);
        if (!VersionFactory.isValidSequence(bigInts)) {
            throw new IllegalArgumentException("Invalid version sequence");
        }
        return new VersionImpl(VersionFactory.toStrings(bigInts));
    }

    private static String[] getStringTokens(String versionString) {
        StringTokenizer tok = new StringTokenizer(versionString, ".");
        String[] result = new String[tok.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tok.nextToken();
            ++i;
        }
        return result;
    }

    private static String[] toStrings(BigInteger[] bigInts) {
        String[] result = new String[bigInts.length];
        int i = 0;
        while (i < result.length) {
            result[i] = bigInts[i].toString();
            ++i;
        }
        return result;
    }

    private static void paramCheck(String methodName, Object param) {
        if (param != null) {
            return;
        }
        String errText = (class$com$sap$sdm$util$version$VersionFactory == null ? (class$com$sap$sdm$util$version$VersionFactory = VersionFactory.class$("com.sap.sdm.util.version.VersionFactory")) : class$com$sap$sdm$util$version$VersionFactory).getName() + "." + methodName + ": parameter is null";
        log.fatal(errText);
        throw new NullPointerException(errText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

