/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.tools;

import com.sap.sdm.util.init.UtilInitializer;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.Conv;
import com.sap.sdm.util.sduread.Dependency;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import java.util.jar.JarInputStream;

public class DCScanner
implements ConstantsIF {
    private static String DIRTAG = "directory";
    private static String DCTAG = "dc";
    private static String DEPENDENCYTAG = "dependency";
    private static String FILETAG = "file";

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage:");
            System.out.println("DCScanner <name of directory> <name of outputfile>");
        } else {
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(args[1]));
                DCScanner dCScanner = new DCScanner(args[0], ps);
            }
            catch (Exception e) {
                System.out.println("error: " + e.getMessage());
            }
        }
    }

    public DCScanner(String directory, PrintStream ps) {
        ps.println("<" + DIRTAG + " name = \"" + directory + "\">");
        String[] flist = this.getArchivesFromDirectory(directory);
        try {
            UtilInitializer.initializeWithSimpleLog();
        }
        catch (Exception e) {
            System.out.println("Error: could not read all necessary SDM property files!");
            System.exit(0);
        }
        int i = 0;
        while (flist != null && i < flist.length) {
            block7: {
                SduFile sdufile;
                try {
                    sdufile = SduReader.getInstance().readFile(flist[i]);
                    if (!(sdufile instanceof SdaFile)) {
                    }
                }
                catch (Exception e) {}
                break block7;
                ps.println("<" + DCTAG);
                ps.println("name = \"" + sdufile.getComponentVersion().getName() + "\"");
                ps.println("vendor = \"" + sdufile.getComponentVersion().getVendor() + "\"");
                ps.println("location = \"" + sdufile.getComponentVersion().getLocation() + "\"");
                ps.println("counter = \"" + sdufile.getComponentVersion().getCount() + "\">");
                ps.println("<" + FILETAG + " name = \"" + new File(flist[i]).getName() + "\"/>");
                Dependency[] deps = ((SdaFile)sdufile).getDependencies();
                int j = 0;
                while (deps != null && j < deps.length) {
                    ps.println("<" + DEPENDENCYTAG);
                    ps.println("name = \"" + deps[j].getName() + "\"");
                    ps.println("vendor = \"" + deps[j].getVendor() + "\"/>");
                    ++j;
                }
                ps.println("</" + DCTAG + ">");
            }
            ++i;
        }
        ps.println("</" + DIRTAG + ">");
    }

    private String[] getArchivesFromDirectory(String directory) {
        Vector<String> temp = new Vector<String>();
        File df = new File(Conv.pathConv(directory));
        if (!df.isDirectory()) {
            return null;
        }
        String[] dflist = df.list();
        int i = 0;
        while (i < dflist.length) {
            dflist[i] = Conv.pathConvJar(df.getPath() + File.separator + dflist[i]);
            if (!new File(Conv.pathConv(dflist[i])).isDirectory()) {
                boolean isarchive = false;
                try {
                    JarInputStream jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(dflist[i]))));
                    if (jis.getManifest() != null || jis.getNextJarEntry() != null) {
                        isarchive = true;
                    }
                    jis.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (isarchive) {
                    temp.addElement(dflist[i]);
                }
            }
            ++i;
        }
        if (temp.size() > 0) {
            String[] result = new String[temp.size()];
            int i2 = 0;
            while (i2 < temp.size()) {
                result[i2] = (String)temp.elementAt(i2);
                ++i2;
            }
            return result;
        }
        return null;
    }
}

