/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.xmlize;

import com.sap.sdm.util.sduread.Dependency;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.xml.AbstractXMLizer;
import com.sap.sdm.xml.XMLElementIF;
import java.util.HashMap;

public class SdaFileXMLizer
extends AbstractXMLizer {
    private static final String NAME = "SdaFile";
    private static final String SDA_FILE_NAME = "SdaFileName";
    private static final String SDA_FILE_VENDOR = "SdaFileVendor";
    private static final String SDA_FILE_LOCATION = "SdaFileLocation";
    private static final String SDA_FILE_COUNT = "SdaFileCount";
    private static final String SDA_FILE_SOFTWARE_TYPE = "SoftwareType";
    private static final String SDA_FILE_DEBUG_INFO = "DebugInfo";
    private static final String SDA_FILE_PATH_NAME = "PathName";
    private static final String SDA_FILE_COMPONENT_TYPE = "ComponentType";
    private static final String SDA_FILE_DEPENDENCIES = "Dependencies";
    private static final String SDA_FILE_DEPENDENCY = "Dependency";
    private static final String SDA_FILE_DEPENDENCY_COMP_NAME = "CompName";
    private static final String SDA_FILE_DEPENDENCY_COMP_VENDOR = "CompVendor";
    public static final int SDA_XML_VERSION_1 = 1;
    public static final int SDA_XML_VERSION_2 = 2;
    private static HashMap sdaXMLizers = new HashMap(1);
    private int version;

    private SdaFileXMLizer(int version) {
        super(NAME);
        this.version = version;
    }

    public static SdaFileXMLizer getInstance() {
        return SdaFileXMLizer.getInstanceByVersion(1);
    }

    public static SdaFileXMLizer getInstanceByVersion(int xmlVersion) {
        Integer key = new Integer(xmlVersion);
        SdaFileXMLizer instance = (SdaFileXMLizer)sdaXMLizers.get(key);
        if (instance == null) {
            instance = new SdaFileXMLizer(xmlVersion);
            sdaXMLizers.put(key, instance);
        }
        return instance;
    }

    public XMLElementIF toXML(SdaFile sdaFile) {
        switch (this.version) {
            case 1: {
                return this.toXML_V1(sdaFile);
            }
            case 2: {
                return this.toXML_V2(sdaFile);
            }
        }
        return this.toXML_V1(sdaFile);
    }

    private XMLElementIF toXML_V1(SdaFile sdaFile) {
        XMLElementIF result = this.createRootElem();
        result.add(this.createElemWithNameAndContent(SDA_FILE_NAME, sdaFile.getComponentVersion().getName()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_VENDOR, sdaFile.getComponentVersion().getVendor()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_LOCATION, sdaFile.getComponentVersion().getLocation()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_COUNT, sdaFile.getComponentVersion().getCount().toString()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_SOFTWARE_TYPE, sdaFile.getSoftwareType()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_DEBUG_INFO, sdaFile.getDebugInfo()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_PATH_NAME, sdaFile.getPathName()));
        String compType = sdaFile.getComponentElement() == null ? "DC" : sdaFile.getComponentElement().getComponentType();
        result.add(this.createElemWithNameAndContent(SDA_FILE_COMPONENT_TYPE, compType));
        return result;
    }

    private XMLElementIF toXML_V2(SdaFile sdaFile) {
        XMLElementIF result = this.createRootElem();
        result.add(this.createElemWithNameAndContent(SDA_FILE_NAME, sdaFile.getComponentVersion().getName()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_VENDOR, sdaFile.getComponentVersion().getVendor()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_LOCATION, sdaFile.getComponentVersion().getLocation()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_COUNT, sdaFile.getComponentVersion().getCount().toString()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_SOFTWARE_TYPE, sdaFile.getSoftwareType()));
        Dependency[] dependencies = sdaFile.getDependencies();
        XMLElementIF dependenciesEl = this.createElemWithName(SDA_FILE_DEPENDENCIES);
        if (dependencies != null && dependencies.length != 0) {
            int i = 0;
            while (i < dependencies.length) {
                XMLElementIF dependencyEl = this.createElemWithName(SDA_FILE_DEPENDENCY);
                XMLElementIF compName = this.createElemWithNameAndContent(SDA_FILE_DEPENDENCY_COMP_NAME, dependencies[i].getName());
                XMLElementIF compVendor = this.createElemWithNameAndContent(SDA_FILE_DEPENDENCY_COMP_VENDOR, dependencies[i].getVendor());
                dependencyEl.add(compName);
                dependencyEl.add(compVendor);
                dependenciesEl.add(dependencyEl);
                ++i;
            }
        }
        result.add(dependenciesEl);
        result.add(this.createElemWithNameAndContent(SDA_FILE_DEBUG_INFO, sdaFile.getDebugInfo()));
        result.add(this.createElemWithNameAndContent(SDA_FILE_PATH_NAME, sdaFile.getPathName()));
        String compType = sdaFile.getComponentElement() == null ? "DC" : sdaFile.getComponentElement().getComponentType();
        result.add(this.createElemWithNameAndContent(SDA_FILE_COMPONENT_TYPE, compType));
        return result;
    }
}

