/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.impl;

import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.VersionedDependency;
import com.sap.sdm.util.version.Version;
import com.sap.sdm.util.version.VersionFactory;

public class VersionedDependencyImpl
implements VersionedDependency {
    String name = null;
    String vendor = null;
    Version count = null;

    VersionedDependencyImpl(String name, String vendor, String counter) throws IllFormattedSduFileException {
        this.name = name;
        this.vendor = vendor;
        String error = "";
        if (!VersionFactory.isValidVersionString(counter)) {
            throw new IllFormattedSduFileException("counter has a wrong format: " + counter);
        }
        this.count = VersionFactory.createVersion(counter);
        if (this.name == null || this.name.trim().equals("")) {
            error = error + "no name defined in dependency,";
        }
        if (this.vendor == null || this.vendor.trim().equals("")) {
            error = error + "no vendor defined in dependency,";
        }
        if (this.count == null) {
            error = error + "no counter defined in dependency,";
        }
        if (!error.equals("")) {
            throw new IllFormattedSduFileException(error);
        }
    }

    public Version getCount() {
        return this.count;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        return "Dependency: name: '" + this.name + "' vendor: '" + this.vendor + "' counter: '" + this.count.toString() + "'.";
    }

    public boolean equals(Object other) {
        return other instanceof VersionedDependency && ((VersionedDependency)other).getName().equals(this.getName()) && ((VersionedDependency)other).getCount().equals(this.getCount()) && ((VersionedDependency)other).getVendor().equals(this.getVendor());
    }

    public int hashCode() {
        return 0;
    }
}

