/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.impl;

import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.Dependency;
import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.impl.VersionedDependencyImpl;
import java.util.StringTokenizer;
import java.util.Vector;

final class DependencyImpl
implements Dependency,
ConstantsIF {
    String name = null;
    String vendor = null;

    DependencyImpl(String name, String vendor) throws IllFormattedSduFileException {
        this.name = name;
        this.vendor = vendor;
        String error = "";
        if (name == null || name.trim().equals("")) {
            error = error + "no name defined in dependency,";
        }
        if (vendor == null || vendor.trim().equals("")) {
            error = error + "no vendor defined in dependency,";
        }
        if (!error.equals("")) {
            throw new IllFormattedSduFileException(error);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        return "Dependency: name: '" + this.name + "' vendor: '" + this.vendor + "'.";
    }

    public boolean equals(Object other) {
        return other instanceof Dependency && ((Dependency)other).getName().equals(this.getName()) && ((Dependency)other).getVendor().equals(this.getVendor());
    }

    public int hashCode() {
        return 0;
    }

    static Dependency[] createDependencies(JarSL jarsl) throws IllFormattedSduFileException {
        Vector<Dependency> deps = new Vector<Dependency>();
        String name = null;
        String vendor = null;
        String counter = null;
        boolean error = false;
        boolean founddeptag = false;
        boolean addtoken = false;
        String pvalue = null;
        String value = jarsl.readAttribute("", "dependencylist");
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        int maxtoken = st.countTokens();
        int i = 0;
        while (i < maxtoken && !error) {
            int i2;
            int i1;
            if (addtoken) {
                pvalue = pvalue + " " + st.nextToken();
                addtoken = false;
            } else {
                pvalue = st.nextToken();
            }
            if (pvalue.compareTo("<dependency") == 0) {
                if (founddeptag) {
                    error = true;
                } else {
                    name = null;
                    vendor = null;
                    counter = null;
                    founddeptag = true;
                }
            } else if (pvalue.compareTo("/>") == 0) {
                if (!founddeptag) {
                    error = true;
                } else {
                    if (counter != null) {
                        deps.addElement(new VersionedDependencyImpl(name, vendor, counter));
                    } else {
                        deps.addElement(new DependencyImpl(name, vendor));
                    }
                    founddeptag = false;
                }
            } else if (pvalue.indexOf("\"") == pvalue.lastIndexOf("\"")) {
                addtoken = true;
            } else if (founddeptag && (i1 = pvalue.indexOf("keyname=\"")) != -1 && (i2 = pvalue.indexOf("\"", i1 + "keyname=\"".length())) != -1) {
                name = pvalue.substring(i1 + "keyname=\"".length(), i2);
            } else if (founddeptag && (i1 = pvalue.indexOf("keycounter=\"")) != -1 && (i2 = pvalue.indexOf("\"", i1 + "keycounter=\"".length())) != -1) {
                counter = pvalue.substring(i1 + "keycounter=\"".length(), i2);
            } else if (founddeptag && (i1 = pvalue.indexOf("keyvendor=\"")) != -1 && (i2 = pvalue.indexOf("\"", i1 + "keyvendor=\"".length())) != -1) {
                vendor = pvalue.substring(i1 + "keyvendor=\"".length(), i2);
            } else {
                error = true;
            }
            ++i;
        }
        if (!error && !founddeptag) {
            Dependency[] dependencies = new Dependency[deps.size()];
            int i2 = 0;
            while (i2 < deps.size()) {
                dependencies[i2] = (Dependency)deps.elementAt(i2);
                ++i2;
            }
            return dependencies;
        }
        throw new IllFormattedSduFileException("wrong syntax in dependency attribute");
    }
}

