/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.matrix;

import com.sap.sdm.util.matrix.NoSuchPermutationException;
import java.util.Arrays;

public class PermutationFinder {
    private static final int NOT_MAPPED = -1;
    private boolean[][] matrix;
    private int[] resultingPermutation = null;
    private boolean[] currentSearchPattern = null;

    private PermutationFinder(boolean[][] matrix) {
        this.matrix = matrix;
        this.resultingPermutation = new int[this.matrix.length];
        Arrays.fill(this.resultingPermutation, -1);
        this.currentSearchPattern = new boolean[this.matrix.length];
        Arrays.fill(this.currentSearchPattern, false);
    }

    public static PermutationFinder createFinder(boolean[][] matrix) throws NullPointerException, IllegalArgumentException {
        if (matrix == null) {
            throw new NullPointerException("PermutationFinder: matrix is null.");
        }
        int rows = matrix.length;
        int i = 0;
        while (i < rows) {
            if (matrix[i].length != rows) {
                throw new IllegalArgumentException("PermutationFinder: matrix is not square.");
            }
            ++i;
        }
        return new PermutationFinder(matrix);
    }

    public int[] findPermutation() throws NoSuchPermutationException {
        while (!this.permutationHasBeenCreated()) {
            this.findRowsMatchingCurrentSearchPattern();
            this.relaxSearchPattern();
        }
        return this.resultingPermutation;
    }

    public static int[] getInversePermutation(int[] perm) {
        if (perm == null) {
            throw new NullPointerException("PermutationFinder.getInversePermutation: perm is null");
        }
        int[] invPerm = new int[perm.length];
        Arrays.fill(invPerm, -1);
        int i = 0;
        while (i < perm.length) {
            if (perm[i] < 0 || perm[i] >= perm.length) {
                throw new IllegalArgumentException("PermutationFinder.getInversePermutation: perm[" + Integer.toString(i) + "] = " + Integer.toString(perm[i]));
            }
            invPerm[perm[i]] = i;
            ++i;
        }
        int i2 = 0;
        while (i2 < invPerm.length) {
            if (invPerm[i2] == -1) {
                throw new IllegalArgumentException("PermutationFinder.getInversePermutation: invPerm[" + Integer.toString(i2) + "] is undefined");
            }
            ++i2;
        }
        return invPerm;
    }

    private void findRowsMatchingCurrentSearchPattern() throws NoSuchPermutationException {
        boolean atLeastOneFound = false;
        int i = 0;
        while (i < this.matrix.length) {
            if (!this.isPermutationDefinedFor(i) && this.rowMatchesPattern(i)) {
                this.mapToNextFreeIndex(i);
                atLeastOneFound = true;
            }
            ++i;
        }
        if (!atLeastOneFound) {
            throw new NoSuchPermutationException();
        }
    }

    private boolean rowMatchesPattern(int rowIndex) {
        int i = 0;
        while (i < this.matrix[rowIndex].length) {
            if (this.matrix[rowIndex][i] && !this.currentSearchPattern[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void relaxSearchPattern() {
        int i = 0;
        while (i < this.currentSearchPattern.length) {
            if (this.isPermutationDefinedFor(i)) {
                this.currentSearchPattern[i] = true;
            }
            ++i;
        }
    }

    private boolean isPermutationDefinedFor(int index) {
        return this.resultingPermutation[index] != -1;
    }

    private boolean permutationHasBeenCreated() {
        return !this.isInPermutationImage(-1);
    }

    private void mapToNextFreeIndex(int fromIndex) {
        int i = 0;
        while (this.isInPermutationImage(i)) {
            ++i;
        }
        this.resultingPermutation[fromIndex] = i;
    }

    private boolean isInPermutationImage(int mappedValue) {
        int i = 0;
        while (i < this.resultingPermutation.length) {
            if (this.resultingPermutation[i] == mappedValue) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

