/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.log.simplelog;

import com.sap.sdm.util.log.Trace;
import com.sap.sdm.util.log.TraceFactory;
import com.sap.sdm.util.log.simplelog.SimpleTrace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

final class SimpleTraceFactory
implements TraceFactory {
    private static final String SDMCLIENTPROPERTIESNAME = "SDMClient.properties";
    private static final String SDMCLIENTTRACEFILENAME = "SDMClientTraceFileName";
    private static final SimpleTraceFactory INSTANCE = new SimpleTraceFactory();
    private String tracefilename;
    private boolean isTraceOn;
    private FileWriter fileWriter;

    private SimpleTraceFactory() {
        block5: {
            this.tracefilename = null;
            this.isTraceOn = false;
            this.fileWriter = null;
            Properties properties = new Properties();
            File propertiesFile = new File(SDMCLIENTPROPERTIESNAME);
            if (propertiesFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(propertiesFile);
                    properties.load(fis);
                    this.tracefilename = properties.getProperty(SDMCLIENTTRACEFILENAME);
                    if (this.tracefilename != null) {
                        this.isTraceOn = true;
                        this.fileWriter = new FileWriter(this.tracefilename);
                        this.fileWriter.write("==================================================" + System.getProperty("line.separator"));
                        Date currentTime = new Date();
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MMMMM.dd 'at' hh:mm:ss a");
                        this.fileWriter.write("SDMClient Trace  -  " + formatter.format(currentTime) + System.getProperty("line.separator"));
                        this.fileWriter.write("==================================================" + System.getProperty("line.separator"));
                        this.fileWriter.flush();
                        break block5;
                    }
                    this.isTraceOn = false;
                }
                catch (IOException ioE) {
                    this.isTraceOn = false;
                }
            } else {
                this.isTraceOn = false;
            }
        }
    }

    static TraceFactory getInstance() {
        return INSTANCE;
    }

    public boolean isTracingTurnedOn(Class forClass) {
        return this.isTraceOn;
    }

    public Trace getTrace(Class forClass) {
        return new SimpleTrace(forClass, this.fileWriter);
    }
}

