/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.log.saplogging;

import com.sap.sdm.util.Date;
import com.sap.sdm.util.log.LogConfiguration;
import com.sap.sdm.util.log.LogConfigurationException;
import com.sap.sdm.util.log.LogFileHandle;
import com.sap.sdm.util.log.saplogging.SapLogFileHandle;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.TraceFormatter;
import java.util.HashMap;
import java.util.Map;

final class SapLogConfiguration
extends LogConfiguration {
    static final String LOGGER_NAME = "SDMLogger";
    private static final String LOGGER_FILENAME = "sdmlog" + Date.getCurrentDateString() + ".log";
    private static final TraceFormatter LOGGER_FORMATTER = new TraceFormatter("%24d %s: %m");
    private static final int LOGGER_SEVERITY = 300;
    private static final boolean LOGGER_APPEND_FILE = true;
    static final String GUI_LOGGER_NAME = "SDMGuiLogger";
    private static final String GUI_LOGGER_FILENAME = "sdmgui" + Date.getCurrentDateString() + ".log";
    private static final TraceFormatter GUI_LOGGER_FORMATTER = new TraceFormatter("%24d %s: %m");
    private static final int GUI_LOGGER_SEVERITY = 300;
    private static final boolean GUI_LOGGER_APPEND_FILE = true;
    static final SapLogConfiguration INSTANCE = new SapLogConfiguration();
    private String logDirectory;
    private final Map fileLogMap = new HashMap();
    private ConsoleLog consoleLog;

    private SapLogConfiguration() {
    }

    public void configureLogging(String logDirName) throws LogConfigurationException {
        this.logDirectory = logDirName;
        this.addLogger(logDirName);
        this.addGuiLogger(logDirName);
    }

    public LogFileHandle startLoggingTo(String logFileName) throws LogConfigurationException {
        if (logFileName == null) {
            return null;
        }
        SapLogFileHandle handle = new SapLogFileHandle(logFileName);
        FileLog additionalFileLog = new FileLog(logFileName, (Formatter)LOGGER_FORMATTER, false);
        Location.getLocation((String)LOGGER_NAME).addLog((Log)additionalFileLog);
        this.fileLogMap.put(handle, additionalFileLog);
        return handle;
    }

    public void endLoggingTo(LogFileHandle handle) {
        FileLog additionalFileLog = (FileLog)this.fileLogMap.get(handle);
        if (additionalFileLog == null) {
            return;
        }
        Location.getLocation((String)LOGGER_NAME).removeLog((Log)additionalFileLog);
        this.fileLogMap.remove(handle);
    }

    public void startLoggingToConsole() {
        if (this.consoleLog == null) {
            this.consoleLog = new ConsoleLog((Formatter)new TraceFormatter("%s: %m"));
            Location.getLocation((String)LOGGER_NAME).addLog((Log)this.consoleLog);
        }
    }

    public void endLoggingToConsole() {
        if (this.consoleLog != null) {
            Location.getLocation((String)LOGGER_NAME).removeLog((Log)this.consoleLog);
            this.consoleLog = null;
        }
    }

    public String getLogDir() {
        return this.logDirectory;
    }

    public String getLogPathName() {
        return this.logDirectory + LOGGER_FILENAME;
    }

    public String getLogFileName() {
        return LOGGER_FILENAME;
    }

    public String getGuiLogPathName() {
        return this.logDirectory + GUI_LOGGER_FILENAME;
    }

    private void addLogger(String logDirName) throws LogConfigurationException {
        FileLog fl = new FileLog(logDirName + LOGGER_FILENAME, (Formatter)LOGGER_FORMATTER, true);
        Location.getLocation((String)LOGGER_NAME).addLog((Log)fl);
        Location.getLocation((String)LOGGER_NAME).setEffectiveSeverity(300);
    }

    private void addGuiLogger(String logDirName) throws LogConfigurationException {
        FileLog fl = new FileLog(logDirName + GUI_LOGGER_FILENAME, (Formatter)GUI_LOGGER_FORMATTER, true);
        Location.getLocation((String)GUI_LOGGER_NAME).addLog((Log)fl);
        Location.getLocation((String)GUI_LOGGER_NAME).setEffectiveSeverity(300);
    }
}

