/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.graph.impl;

import com.sap.sdm.util.graph.DiEdge;
import com.sap.sdm.util.graph.DiGraph;
import com.sap.sdm.util.graph.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class DiGraphImpl
implements DiGraph {
    protected Node[] nodes;
    protected DiEdge[] edges;
    private Map nodeNumbersOrig;
    private boolean[][] adjacenceMatrix;
    private boolean isAcyclic;
    private boolean isAcyclicDetermined;
    private int currentTopSortNumber;
    private boolean[] topSortProcessed;
    private int[] topSortNumbers;
    private boolean[] nodeVisited;
    private boolean[] nodeExited;
    private int cycleCount;
    private Set[] cycles;
    private boolean cyclesDetermined;
    private Stack cycleStack;
    private List cycleList;

    DiGraphImpl(Node[] nodes, DiEdge[] edges) {
        this.nodes = nodes;
        this.edges = edges;
        this.isAcyclicDetermined = false;
        this.cyclesDetermined = false;
        this.nodeNumbersOrig = new HashMap();
        int i = 0;
        while (i < nodes.length) {
            this.nodeNumbersOrig.put(nodes[i], new Integer(i));
            ++i;
        }
        this.adjacenceMatrix = new boolean[nodes.length][nodes.length];
        int i2 = 0;
        while (i2 < nodes.length) {
            int j = 0;
            while (j < nodes.length) {
                this.adjacenceMatrix[i2][j] = false;
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < edges.length) {
            int numberStartNode = (Integer)this.nodeNumbersOrig.get(edges[i3].getStartNode());
            int numberEndNode = (Integer)this.nodeNumbersOrig.get(edges[i3].getEndNode());
            this.adjacenceMatrix[numberStartNode][numberEndNode] = true;
            ++i3;
        }
    }

    public int getNodeNumberOrig(Node node) {
        return (Integer)this.nodeNumbersOrig.get(node);
    }

    public Node getNodeForUserObject(Object obj) {
        int i = 0;
        while (i < this.nodes.length) {
            if (obj.equals(this.nodes[i].getUserObject())) {
                return this.nodes[i];
            }
            ++i;
        }
        return null;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public Node[] getSourceNodes() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        int i = 0;
        while (i < this.nodes.length) {
            boolean drainFound = false;
            int j = 0;
            while (j < this.nodes.length) {
                if (this.adjacenceMatrix[j][i]) {
                    drainFound = true;
                    break;
                }
                ++j;
            }
            if (!drainFound) {
                nodeList.add(this.nodes[i]);
            }
            ++i;
        }
        Node[] sourceNodes = new Node[nodeList.size()];
        nodeList.toArray(sourceNodes);
        return sourceNodes;
    }

    public Node[] getDrainNodes() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        int i = 0;
        while (i < this.nodes.length) {
            boolean sourceFound = false;
            int j = 0;
            while (j < this.nodes.length) {
                if (this.adjacenceMatrix[i][j]) {
                    sourceFound = true;
                    break;
                }
                ++j;
            }
            if (!sourceFound) {
                nodeList.add(this.nodes[i]);
            }
            ++i;
        }
        Node[] drainNodes = new Node[nodeList.size()];
        nodeList.toArray(drainNodes);
        return drainNodes;
    }

    public DiEdge[] getEdges() {
        return this.edges;
    }

    public Node[] getAdjacentNodesIn(Node node) {
        int nodeNumber = (Integer)this.nodeNumbersOrig.get(node);
        ArrayList<Node> resultList = new ArrayList<Node>();
        int i = 0;
        while (i < this.nodes.length) {
            if (this.adjacenceMatrix[i][nodeNumber]) {
                resultList.add(this.nodes[i]);
            }
            ++i;
        }
        Node[] result = new Node[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public Node[] getAdjacentNodesOut(Node node) {
        int nodeNumber = (Integer)this.nodeNumbersOrig.get(node);
        ArrayList<Node> resultList = new ArrayList<Node>();
        int i = 0;
        while (i < this.nodes.length) {
            if (this.adjacenceMatrix[nodeNumber][i]) {
                resultList.add(this.nodes[i]);
            }
            ++i;
        }
        Node[] result = new Node[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public DiEdge[] getEdgesIn(Node node) {
        ArrayList<DiEdge> edgeList = new ArrayList<DiEdge>();
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i].getEndNode().equals(node)) {
                edgeList.add(this.edges[i]);
            }
            ++i;
        }
        DiEdge[] edgesIn = new DiEdge[edgeList.size()];
        edgeList.toArray(edgesIn);
        return edgesIn;
    }

    public DiEdge[] getEdgesOut(Node node) {
        ArrayList<DiEdge> edgeList = new ArrayList<DiEdge>();
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i].getStartNode().equals(node)) {
                edgeList.add(this.edges[i]);
            }
            ++i;
        }
        DiEdge[] edgesOut = new DiEdge[edgeList.size()];
        edgeList.toArray(edgesOut);
        return edgesOut;
    }

    public boolean areNodesAdjacent(Node startNode, Node endNode) {
        int startNodeNumber = (Integer)this.nodeNumbersOrig.get(startNode);
        int endNodeNumber = (Integer)this.nodeNumbersOrig.get(endNode);
        return this.adjacenceMatrix[startNodeNumber][endNodeNumber];
    }

    public boolean isAcyclic() {
        if (this.isAcyclicDetermined) {
            return this.isAcyclic;
        }
        boolean containsCycle = this.topSortCyclicTest(this);
        this.isAcyclicDetermined = true;
        boolean bl = this.isAcyclic = !containsCycle;
        if (this.isAcyclic) {
            this.cyclesDetermined = true;
            this.cycles = new Set[0];
        }
        return this.isAcyclic;
    }

    private boolean topSortCyclicTest(DiGraph graph) {
        Node[] topSortNodes = graph.getNodes();
        this.topSortProcessed = new boolean[topSortNodes.length];
        this.topSortNumbers = new int[topSortNodes.length];
        this.currentTopSortNumber = topSortNodes.length - 1;
        boolean cycleFound = false;
        int i = 0;
        while (i < this.topSortProcessed.length) {
            this.topSortProcessed[i] = false;
            this.topSortNumbers[i] = -1;
            ++i;
        }
        try {
            int i2 = 0;
            while (i2 < topSortNodes.length) {
                if (!this.topSortProcessed[i2]) {
                    this.topSortProc(i2, graph);
                }
                ++i2;
            }
        }
        catch (CycleFoundException cfe) {
            cycleFound = true;
        }
        return cycleFound;
    }

    private void topSortProc(int i, DiGraph graph) throws CycleFoundException {
        this.topSortProcessed[i] = true;
        Node[] nodesAdjacentOut = graph.getAdjacentNodesOut(graph.getNodes()[i]);
        int j = 0;
        while (j < nodesAdjacentOut.length) {
            int nodeNo = graph.getNodeNumberOrig(nodesAdjacentOut[j]);
            if (!this.topSortProcessed[nodeNo]) {
                this.topSortProc(nodeNo, graph);
            } else if (this.topSortNumbers[nodeNo] == -1) {
                throw new CycleFoundException("Cycle found");
            }
            ++j;
        }
        this.topSortNumbers[i] = this.currentTopSortNumber--;
    }

    public Set[] getCycles() {
        if (this.cyclesDetermined) {
            return this.cycles;
        }
        this.cycleList = new ArrayList();
        this.cycleStack = new Stack();
        this.nodeVisited = new boolean[this.nodes.length];
        this.nodeExited = new boolean[this.nodes.length];
        int i = 0;
        while (i < this.nodes.length) {
            this.nodeVisited[i] = false;
            this.nodeExited[i] = false;
            ++i;
        }
        this.cycleCount = 0;
        int i2 = 0;
        while (i2 < this.nodes.length) {
            if (!this.nodeVisited[i2]) {
                this.cycleSearch(i2, this);
            }
            ++i2;
        }
        this.cyclesDetermined = true;
        this.cycles = new Set[this.cycleList.size()];
        this.cycleList.toArray(this.cycles);
        return this.cycles;
    }

    private void cycleSearch(int i, DiGraph graph) {
        this.nodeVisited[i] = true;
        Node currentNode = graph.getNodes()[i];
        this.cycleStack.push(currentNode);
        Node[] nodesAdjacentOut = graph.getAdjacentNodesOut(currentNode);
        int j = 0;
        while (j < nodesAdjacentOut.length) {
            int nodeNo = graph.getNodeNumberOrig(nodesAdjacentOut[j]);
            if (!this.nodeVisited[nodeNo]) {
                this.cycleSearch(nodeNo, graph);
            } else if (!this.nodeExited[nodeNo]) {
                ++this.cycleCount;
                HashSet<Node> newNodeSet = new HashSet<Node>();
                Stack<Node> dummyStack = new Stack<Node>();
                Node cycleNode = (Node)this.cycleStack.pop();
                newNodeSet.add(cycleNode);
                dummyStack.push(cycleNode);
                while (!cycleNode.equals(nodesAdjacentOut[j])) {
                    cycleNode = (Node)this.cycleStack.pop();
                    newNodeSet.add(cycleNode);
                    dummyStack.push(cycleNode);
                }
                while (!dummyStack.isEmpty()) {
                    this.cycleStack.push(dummyStack.pop());
                }
                this.cycleList.add(newNodeSet);
            }
            ++j;
        }
        this.nodeExited[i] = true;
        this.cycleStack.pop();
    }

    public DiGraph constructSubgraph(Node nodeToBeRemoved) {
        HashSet<Node> allNodes = new HashSet<Node>();
        int i = 0;
        while (i < this.nodes.length) {
            allNodes.add(this.nodes[i]);
            ++i;
        }
        allNodes.remove(nodeToBeRemoved);
        Node[] subgraphNodes = new Node[allNodes.size()];
        allNodes.toArray(subgraphNodes);
        ArrayList<DiEdge> edgesList = new ArrayList<DiEdge>();
        int i2 = 0;
        while (i2 < this.edges.length) {
            if (!this.edges[i2].getStartNode().equals(nodeToBeRemoved) && !this.edges[i2].getEndNode().equals(nodeToBeRemoved)) {
                edgesList.add(this.edges[i2]);
            }
            ++i2;
        }
        DiEdge[] subgraphEdges = new DiEdge[edgesList.size()];
        edgesList.toArray(subgraphEdges);
        return new DiGraphImpl(subgraphNodes, subgraphEdges);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Nodes: \n");
        int i = 0;
        while (i < this.nodes.length) {
            buf.append(this.nodes[i].getName() + "\n");
            ++i;
        }
        buf.append("\nEdges: \n");
        int i2 = 0;
        while (i2 < this.edges.length) {
            buf.append(this.edges[i2].toString());
            buf.append("\n");
            ++i2;
        }
        return buf.toString();
    }

    private class CycleFoundException
    extends Exception {
        CycleFoundException(String msg) {
            super(msg);
        }
    }
}

