/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class TinyIntHandler
extends FieldHandler {
    TinyIntHandler(String name) {
        super(name, -6);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        stmt.setByte(columnNumber, jarsl.getByteData());
    }

    String readValue(JarSL jarsl) throws IOException {
        return new Byte(jarsl.getByteData()).toString();
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        stmt.setByte(columnNumber, new Byte(value));
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    byte getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getByte(columnNumber);
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        jarsl.putByteData(rs.getByte(columnNumber));
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

