/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

class TimestampHandler
extends FieldHandler {
    TimestampHandler(String name) {
        super(name, 93);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        long l = jarsl.getLongData();
        if (l == -1L) {
            this.initialize(stmt, columnNumber);
        } else {
            stmt.setTimestamp(columnNumber, this.createTimestamp(l));
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        long l = jarsl.getLongData();
        if (l == -1L) {
            return "<NULL>";
        }
        return new Long(l).toString() + " (" + this.createTimestamp(l).toString() + ")";
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        long l = new Long(value);
        if (l == -1L) {
            this.initialize(stmt, columnNumber);
        } else {
            stmt.setTimestamp(columnNumber, this.createTimestamp(l));
        }
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    long getValue(ResultSet rs, int columnNumber) throws SQLException {
        return ((Date)rs.getTimestamp(columnNumber)).getTime();
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        Timestamp timestamp = rs.getTimestamp(columnNumber, Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        if (timestamp != null) {
            jarsl.putLongData(((Date)timestamp).getTime());
        } else {
            jarsl.putLongData(-1L);
        }
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }

    private Timestamp createTimestamp(long l) {
        long timezoneoffset = new Timestamp(l).getTimezoneOffset() * 60 * 1000;
        return new Timestamp(l + timezoneoffset);
    }
}

