/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldDescription;
import com.sap.sdm.util.dbaccess.TableDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TableDescriptionFactory {
    public static TableDescriptionFactory instance = null;
    private TableDescription currentTableDescription = null;

    private TableDescriptionFactory() {
    }

    public static final synchronized TableDescriptionFactory getInstance() {
        if (instance == null) {
            instance = new TableDescriptionFactory();
        }
        return instance;
    }

    public TableDescription getTableDescription(Connection connection, String tablename) throws SQLException {
        if (this.currentTableDescription == null || !this.currentTableDescription.getName().equals(tablename)) {
            try {
                this.currentTableDescription = new TableDescription(tablename);
                PreparedStatement ps = connection.prepareStatement("SELECT * FROM " + tablename);
                ResultSetMetaData rsmd = null;
                try {
                    rsmd = ps.getMetaData();
                }
                catch (SQLException e) {
                    ps.execute();
                    rsmd = ps.getMetaData();
                }
                int numberOfColumns = rsmd.getColumnCount();
                if (numberOfColumns <= 0) {
                    throw new SQLException("old jdbc driver => problem in java.sql.ResultSetMetaData.getColumnCount()");
                }
                int i = 0;
                while (i < numberOfColumns) {
                    int clen;
                    String cname = rsmd.getColumnName(i + 1);
                    int ctype = rsmd.getColumnType(i + 1);
                    switch (ctype) {
                        case -2: 
                        case -1: 
                        case 12: {
                            clen = rsmd.getPrecision(i + 1);
                            break;
                        }
                        case 2004: 
                        case 2005: {
                            clen = Integer.MAX_VALUE;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            clen = 0;
                            break;
                        }
                        default: {
                            clen = rsmd.getScale(i + 1);
                        }
                    }
                    this.currentTableDescription.addFieldDescription(new FieldDescription(cname, ctype, clen));
                    ++i;
                }
                ps.close();
            }
            catch (SQLException e) {
                this.currentTableDescription = null;
                throw e;
            }
        }
        return this.currentTableDescription;
    }
}

