/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class DoubleHandler
extends FieldHandler {
    DoubleHandler(String name) {
        super(name, 8);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        stmt.setDouble(columnNumber, jarsl.getDoubleData());
    }

    String readValue(JarSL jarsl) throws IOException {
        return new Double(jarsl.getDoubleData()).toString();
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        stmt.setDouble(columnNumber, new Double(value));
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    double getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getDouble(columnNumber);
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        jarsl.putDoubleData(rs.getDouble(columnNumber));
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

