/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.AbstractSelectionReader;
import com.sap.sdm.util.dbaccess.DBTaskLogger;
import com.sap.sdm.util.dbaccess.DeploymentDescriptor;
import com.sap.sdm.util.dbaccess.FileLengthReader;
import com.sap.sdm.util.dbaccess.SapTransVersion;
import com.sap.sdm.util.dbaccess.Selection;
import com.sap.sdm.util.dbaccess.TableAccess;
import com.sap.sdm.util.dbaccess.TableEntry;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBTask {
    public static final int IMPORTMODE_DEFAULT = 0;
    public static final int IMPORTMODE_NODELETE = 1;
    public static final int IMPORTMODE_NOUPDATE = 2;
    public static final int IMPORTMODE_INSERTONLY = 3;
    public static final int IMPORTMODE_DELETEONLY = 4;
    private Connection con = null;
    private String driver;
    private String url;
    private String user;
    private String passwd;
    private ArrayList selectionList;
    private ArrayList entryList;
    private PrintWriter logFile = null;
    private String externalLogFileName = null;
    private boolean testmode = false;
    private boolean allow_delete = true;
    private boolean allow_insert = true;
    private boolean allow_update = true;
    private boolean useLogger = false;
    private boolean openConnectionWasProvided = false;
    private DBTaskLogger logging = null;
    private Exception first_exception = null;

    public DBTask(String driver, String url, String user, String passwd) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
        this.openConnectionWasProvided = false;
    }

    public DBTask(Connection connection) {
        this.con = connection;
        this.openConnectionWasProvided = true;
    }

    public void useLogger(boolean useLogger) {
        this.useLogger = useLogger;
        if (useLogger) {
            this.logging = new DBTaskLogger();
        }
    }

    public void useLogger(String fileName) {
        this.useLogger = false;
        this.externalLogFileName = fileName;
    }

    public boolean testconnect() {
        try {
            this.logging = this.useLogger ? new DBTaskLogger() : new DBTaskLogger("testconn.log", false);
            if (null != this.con && !this.con.isClosed()) {
                this.logging.message("testconnect(): DBTask already has a connection defined. There is no need to perform a connect/disconnect. Keep the connection and return true.");
                return true;
            }
            this.connect();
            this.disconnect();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean dbExport(String selectFileName, JarSL jarsl) throws Exception, IOException, SQLException, ClassNotFoundException {
        try {
            sql_error_cnt = 0;
            errorvec = new Vector<E>();
            archivedirname = jarsl.getArchiveName().getParent() + File.separator + "tempdbtask";
            if (this.useLogger) {
                this.logging = new DBTaskLogger();
            } else if (this.externalLogFileName != null) {
                this.logging = new DBTaskLogger(this.externalLogFileName, true);
            } else {
                logFileName = this.getLogFileName(archivedirname + File.separator + jarsl.getArchiveName().getName(), "exp");
                this.logging = new DBTaskLogger(logFileName, false);
            }
            this.logging.message("--------------------------------------");
            this.logging.message(new SapTransVersion().getSapTransVersion());
            this.logging.message(new SapTransVersion().getSourceId());
            this.logging.message("Start: " + new Date().toString());
            this.logging.message("Select file: " + selectFileName);
            this.logging.message("Output file: " + jarsl.getArchiveName().getPath());
            try {
                jr = AbstractSelectionReader.createSelectionReader(selectFileName);
                jr.parseSelections();
                this.selectionList = jr.getSelectionList();
            }
            catch (Exception e) {
                this.logging.message("ERROR: Cannot read " + selectFileName);
                throw e;
            }
            if (!jarsl.addFile("", selectFileName, "select.xml", errorvec)) {
                tmpB = new StringBuffer();
                if (null != errorvec) {
                    errIter = errorvec.iterator();
                    while (errIter.hasNext()) {
                        tmpB.append((String)errIter.next());
                    }
                    this.logging.message("ERROR: Cannot add the selectfile to the archive: " + tmpB.toString());
                } else {
                    this.logging.message("ERROR: Cannot add the selectfile to the archive");
                }
                return false;
            }
            if (this.selectionList.size() != 0) {
                try {
                    this.connect();
                }
                catch (Exception e) {
                    this.logging.message("ERROR: Cannot connect to the database.");
                    throw e;
                }
                this.logging.message("");
                selection_iterator = this.selectionList.iterator();
                block10: while (selection_iterator.hasNext()) {
                    entry_cnt = 0;
                    selection = (Selection)selection_iterator.next();
                    this.logging.message("now processing " + selection.getTableName() + " (" + selection.getJarEntryName(true) + ")");
                    ta = new TableAccess(this.con);
                    ta.setTestmode(this.testmode);
                    try {
                        entry_cnt = ta.t_export(selection, jarsl, archivedirname);
                        successmessage = "Success: " + Integer.toString(entry_cnt) + " entries from " + selection.getTableName() + " exported";
                        if (selection.getWhereCond() != null) {
                            successmessage.concat(" [" + selection.getWhereCond() + "]");
                        }
                        this.logging.message(successmessage);
                        continue;
                    }
                    catch (SQLException e) {
                        this.logging.message("DB Error: " + selection.getTableName());
                        ** while (e != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++sql_error_cnt;
                        this.logging.message("Message: " + e.getMessage());
                        this.logging.message("SQLState: " + e.getSQLState());
                        this.logging.message("ErrorCode: " + e.getErrorCode());
                        e = e.getNextException();
                        continue;
lbl71:
                        // 1 sources

                        continue block10;
                    }
                    catch (IOException e) {
                        this.logging.message("ERROR: IO error during export");
                        this.disconnect();
                        throw e;
                    }
                }
            } else {
                this.logging.message("no DB connect necessary because the select file doesn't contain selections");
            }
            this.logging.message("");
            this.disconnect();
            this.logging.message("Stop: " + new Date().toString());
            this.logging.message("");
            if (!this.useLogger && this.logFile != null) {
                this.logFile.close();
            }
            if (sql_error_cnt > 0) {
                throw new SQLException(sql_error_cnt + " SQL error(s) occured");
            }
            if (this.testmode) {
                System.out.println("export completed.");
            }
        }
        catch (Exception e) {
            this.logging.message(e);
            throw e;
        }
        return true;
    }

    public static String addDeployFile(String archivename) {
        String archivedirname = new File(archivename).getParent() + File.separator + "tempdbtask";
        String tmpDdFileName = archivedirname + File.separator + "sda-dd.xml";
        try {
            DeploymentDescriptor dd = new DeploymentDescriptor(new File(archivename).getName(), tmpDdFileName);
        }
        catch (IOException e) {
            return null;
        }
        return tmpDdFileName;
    }

    /*
     * Unable to fully structure code
     */
    public boolean dbImport(String datafilename) throws IOException, SQLException, ClassNotFoundException, Exception {
        try {
            sql_error_cnt = 0;
            errorvec = new Vector<E>();
            archivedirname = new File(datafilename).getParent() + File.separator + "tempdbtask";
            if (this.useLogger) {
                this.logging = new DBTaskLogger();
            } else if (this.externalLogFileName != null) {
                this.logging = new DBTaskLogger(this.externalLogFileName, true);
            } else {
                logFileName = this.getLogFileName(archivedirname + File.separator + new File(datafilename).getName(), "imp");
                this.logging = new DBTaskLogger("testconn.log", false);
            }
            this.logging.message("--------------------------------------");
            this.logging.message(new SapTransVersion().getSapTransVersion());
            this.logging.message(new SapTransVersion().getSourceId());
            this.logging.message("Start: " + new Date().toString());
            this.logging.message("Input file: " + datafilename);
            this.printImportMode();
            jarsl = new JarSL(datafilename, archivedirname);
            if (!jarsl.extractSingleFile("select.xml", errorvec)) {
                tmpB = new StringBuffer();
                if (null != errorvec) {
                    errIter = errorvec.iterator();
                    while (errIter.hasNext()) {
                        tmpB.append((String)errIter.next());
                    }
                    this.logging.message("ERROR: Cannot read the selectfile from the datafile: " + tmpB.toString());
                } else {
                    this.logging.message("ERROR: Cannot read the selectfile from the datafile " + datafilename + ".");
                }
                return false;
            }
            try {
                jr = AbstractSelectionReader.createSelectionReader(archivedirname + File.separator + "select.xml");
                jr.parseSelections();
                this.selectionList = jr.getSelectionList();
                this.entryList = jr.getEntryList();
            }
            catch (Exception e) {
                this.logging.message("ERROR: Cannot read " + archivedirname + File.separator + "select.xml");
                throw new Exception("ERROR: Cannot read " + archivedirname + File.separator + "select.xml: " + e.getMessage());
            }
            try {
                this.connect();
            }
            catch (Exception e) {
                this.logging.message("ERROR: Cannot connect to the database.");
                throw new Exception("ERROR: Cannot connect to the database:" + e.getMessage());
            }
            iter = this.selectionList.iterator();
            while (iter.hasNext()) {
                selection = (Selection)iter.next();
                this.logging.message("now processing " + selection.getTableName() + " (" + selection.getJarEntryName(true) + ")");
                try {
                    block46: {
                        ta = new TableAccess(this.con, this.logging);
                        ta.setTestmode(this.testmode);
                        ta.setUpdateMode(this.allow_update);
                        if (this.testmode) {
                            ta.setCommitCount(10);
                        }
                        if (this.allow_delete) {
                            try {
                                entry_cnt = ta.t_delete(selection);
                                successmessage = "Success: " + Integer.toString(entry_cnt) + " entries from " + selection.getTableName() + " deleted";
                                if (selection.getWhereCond() != null) {
                                    successmessage.concat(" [" + selection.getWhereCond() + "]");
                                }
                                this.logging.message(successmessage);
                                if (this.testmode) break block46;
                                this.logging.message(ta.commit(false));
                            }
                            catch (SQLException e) {
                                ** while (e != null)
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.logging.message("delete failed with message: " + e.getMessage());
                                this.logging.message("Maybe the problem is caused by an ugly where clause. Please refer to note 718754.");
                                e = e.getNextException();
                                continue;
                            }
                        }
                    }
                    if (!this.allow_insert) continue;
                    try {
                        entry_cnt = ta.t_import(selection, jarsl);
                        successmessage = "Success: " + Integer.toString(entry_cnt) + " entries for " + selection.getTableName() + " imported";
                        if (selection.getWhereCond() != null) {
                            successmessage.concat(" [" + selection.getWhereCond() + "]");
                        }
                        this.logging.message(successmessage);
                        if (ta.getDupCount() > 0) {
                            this.logging.message("(" + ta.getDupCount() + " entries existed already)");
                        }
                        this.logging.message(ta.commit(false));
                        continue;
                    }
                    catch (SQLException e) {
                        this.logging.message("DB Error: " + selection.getTableName());
                        ** while (e != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++sql_error_cnt;
                        if (this.first_exception == null) {
                            this.first_exception = e;
                        }
                        this.logging.message("Message: " + e.getMessage());
                        this.logging.message("SQLState: " + e.getSQLState());
                        this.logging.message("ErrorCode: " + e.getErrorCode());
                        e = e.getNextException();
                        continue;
                    }
lbl98:
                    // 1 sources

                    jarsl.closeSingleArchiveFile(null);
                }
                catch (NoSuchElementException e) {
                    this.logging.message("ERROR: " + e.getMessage());
                    this.disconnect();
                    throw new Exception("ERROR: " + e.getMessage());
                }
                catch (IOException e) {
                    this.disconnect();
                    throw new Exception("ERROR IOException: " + e.getMessage());
                }
            }
            iter = this.entryList.iterator();
            block23: while (iter.hasNext()) {
                tableentry = (TableEntry)iter.next();
                this.logging.message("now processing entry for table " + tableentry.getTableName() + " (" + tableentry.getId() + ")");
                try {
                    block47: {
                        ta = new TableAccess(this.con);
                        ta.setTestmode(this.testmode);
                        ta.setUpdateMode(this.allow_update);
                        if (this.testmode) {
                            ta.setCommitCount(10);
                        }
                        if (this.allow_delete && !this.allow_insert) {
                            try {
                                entry_cnt = ta.t_delete(tableentry);
                                successmessage = "Success: " + Integer.toString(entry_cnt) + " entries from " + tableentry.getTableName() + " deleted";
                                this.logging.message(successmessage);
                                if (this.testmode) break block47;
                                this.logging.message(ta.commit(false));
                            }
                            catch (SQLException e) {
                                ** while (e != null)
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.logging.message("delete failed with message: " + e.getMessage());
                                this.logging.message("Maybe the problem is caused by ugly names or values. Please refer to note 718754.");
                                e = e.getNextException();
                                continue;
                            }
                        }
                    }
                    if (!this.allow_insert) continue;
                    try {
                        entry_cnt = ta.t_create(tableentry);
                        this.logging.message((entry_cnt > 0 ? "Success: " : "Failure: ") + Integer.toString(entry_cnt) + " entries for " + tableentry.getTableName() + " created");
                        if (ta.getDupCount() > 0) {
                            this.logging.message("(" + ta.getDupCount() + " entries existed already)");
                        }
                        this.logging.message(ta.commit(false));
                        continue;
                    }
                    catch (SQLException e) {
                        this.logging.message("DB Error: " + tableentry.getTableName());
                        ** while (e != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++sql_error_cnt;
                        if (this.first_exception == null) {
                            this.first_exception = e;
                        }
                        this.logging.message("Message: " + e.getMessage());
                        this.logging.message("SQLState: " + e.getSQLState());
                        this.logging.message("ErrorCode: " + e.getErrorCode());
                        e = e.getNextException();
                        continue;
lbl152:
                        // 1 sources

                    }
                }
                catch (NoSuchElementException e) {
                    this.logging.message("ERROR: " + e.getMessage());
                    this.disconnect();
                    throw new Exception("ERROR: " + e.getMessage());
                }
            }
            ta = new TableAccess(this.con);
            ta.setTestmode(this.testmode);
            this.logging.message(ta.commit(true));
            this.disconnect();
            FileLengthReader.getInstance().reset();
            if (sql_error_cnt > 0) {
                this.logging.message(sql_error_cnt + " SQL error(s) occured");
                if (this.first_exception == null) {
                    throw new SQLException(sql_error_cnt + " SQL error(s) occured");
                }
                throw this.first_exception;
            }
            this.logging.message("Stop: " + new Date().toString());
            if (!this.useLogger && this.logFile != null) {
                this.logFile.close();
            }
        }
        catch (Exception e) {
            this.logging.message(e);
            throw e;
        }
        return true;
    }

    public boolean display(String datafilename) throws IOException {
        Vector errorvec = new Vector();
        String archivedirname = new File(datafilename).getParent() + File.separator + "tempdbtask";
        if (this.useLogger) {
            this.logging = new DBTaskLogger();
        } else if (this.externalLogFileName != null) {
            this.logging = new DBTaskLogger(this.externalLogFileName, true);
        } else {
            String logFileName = this.getLogFileName(archivedirname + File.separator + new File(datafilename).getName(), "imp");
            this.logging = new DBTaskLogger("testconn.log", false);
        }
        this.logging.message("--------------------------------------");
        this.logging.message(new SapTransVersion().getSapTransVersion());
        this.logging.message(new SapTransVersion().getSourceId());
        this.logging.message("Start: " + new Date().toString());
        this.logging.message("Input file: " + datafilename);
        this.printImportMode();
        JarSL jarsl = new JarSL(datafilename, archivedirname);
        if (!jarsl.extractSingleFile("select.xml", errorvec)) {
            StringBuffer tmpB = new StringBuffer();
            if (null != errorvec) {
                Iterator errIter = ((AbstractList)errorvec).iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
                this.logging.message("ERROR: Cannot read the selectfile from the datafile: " + tmpB.toString());
            } else {
                this.logging.message("ERROR: Cannot read the selectfile from the datafile " + datafilename + ".");
            }
            return false;
        }
        try {
            AbstractSelectionReader jr = AbstractSelectionReader.createSelectionReader(archivedirname + File.separator + "select.xml");
            jr.parseSelections();
            this.selectionList = jr.getSelectionList();
            this.entryList = jr.getEntryList();
        }
        catch (Exception e) {
            this.logging.message("ERROR: Cannot read " + archivedirname + File.separator + "select.xml");
            throw new IOException("ERROR: Cannot read " + archivedirname + File.separator + "select.xml: " + e.getMessage());
        }
        Iterator iter = ((AbstractList)this.selectionList).iterator();
        while (iter.hasNext()) {
            Selection selection = (Selection)iter.next();
            this.logging.message("now processing " + selection.getTableName() + " (" + selection.getJarEntryName(true) + ")");
            try {
                TableAccess ta = new TableAccess(this.con, this.logging);
                int entry_cnt = ta.t_display(selection, jarsl);
                String successmessage = "Success: " + Integer.toString(entry_cnt) + " entries for " + selection.getTableName() + " displayed";
                if (selection.getWhereCond() != null) {
                    successmessage.concat(" [" + selection.getWhereCond() + "]");
                }
                this.logging.message(successmessage);
            }
            catch (NoSuchElementException e) {
                this.logging.message("ERROR: " + e.getMessage());
                throw new IOException("ERROR: " + e.getMessage());
            }
            catch (IOException e) {
                this.logging.message("ERROR: " + e.getMessage());
                throw e;
            }
        }
        FileLengthReader.getInstance().reset();
        this.logging.message("Stop: " + new Date().toString());
        if (!this.useLogger && this.logFile != null) {
            this.logFile.close();
        }
        return true;
    }

    private String getLogFileName(String FileName, String extension) {
        int endindex = FileName.lastIndexOf(".");
        if (endindex == -1) {
            return FileName + "_" + extension + ".log";
        }
        return FileName.substring(0, endindex) + "_" + extension + ".log";
    }

    private void connect() throws SQLException, ClassNotFoundException {
        if (this.openConnectionWasProvided) {
            return;
        }
        if (null != this.con && !this.con.isClosed()) {
            return;
        }
        try {
            Driver jdbcDriver = null;
            this.logging.message("Loading JDBC driver '" + this.driver + "' by name.");
            jdbcDriver = (Driver)Class.forName(this.driver).newInstance();
            this.logging.message("JDBC driver " + this.driver + " successfully loaded.");
            DriverManager.registerDriver(jdbcDriver);
            if (null == DriverManager.getDriver(this.url)) {
                this.logging.message("Driver '" + this.driver + "' is not suitable for URL '" + this.url + "'.");
            }
        }
        catch (Exception e) {
            this.logging.message("ERROR: Loading of JDBC driver '" + this.driver + "' failed (" + e.getClass().getName() + "/" + e.getMessage() + ")");
            throw new ClassNotFoundException(this.driver, e);
        }
        try {
            this.logging.message("Connecting to database '" + this.url + "' as user '" + this.user + "'.");
            this.con = DriverManager.getConnection(this.url, this.user, this.passwd);
            this.logging.message("Connected to database '" + this.url + "' as user '" + this.user + "'.");
        }
        catch (SQLException e) {
            if (this.con != null) {
                this.con.close();
            }
            String sss = "ERROR: Connect failed to database " + this.url + " as user " + this.user + " (" + e.getClass().getName() + "/" + e.getMessage() + ")";
            this.logging.message(sss);
            throw new SQLException(sss + ": " + e.getMessage());
        }
        this.con.setAutoCommit(false);
    }

    private void disconnect() throws SQLException {
        if (this.openConnectionWasProvided) {
            return;
        }
        if (this.con != null) {
            this.con.close();
            this.con = null;
            this.logging.message("Disconnected from database");
        }
    }

    private void setTestmode(TableAccess ta, boolean testmode) {
        this.setTestMode(testmode);
        this.setTestmode(ta);
    }

    private void setTestmode(TableAccess ta) {
        ta.setTestmode(this.testmode);
    }

    public void setTestMode(boolean testmode) {
        this.testmode = testmode;
    }

    public void setTestMode() {
        this.testmode = true;
    }

    public void setImportMode(int importmode) {
        switch (importmode) {
            case 3: {
                this.allow_delete = false;
                this.allow_insert = true;
                this.allow_update = false;
                if (this.logging == null) break;
                this.logging.message("importmode = insertonly");
                break;
            }
            case 1: {
                this.allow_delete = false;
                this.allow_insert = true;
                this.allow_update = true;
                if (this.logging == null) break;
                this.logging.message("importmode = nodelete");
                break;
            }
            case 2: {
                this.allow_delete = true;
                this.allow_insert = true;
                this.allow_update = false;
                if (this.logging == null) break;
                this.logging.message("importmode = noupdate");
                break;
            }
            case 4: {
                this.allow_delete = true;
                this.allow_insert = false;
                this.allow_update = false;
                if (this.logging == null) break;
                this.logging.message("importmode = deleteonly");
                break;
            }
            default: {
                this.allow_delete = true;
                this.allow_insert = true;
                this.allow_update = true;
                if (this.logging == null) break;
                this.logging.message("importmode = default");
            }
        }
        if (this.logging != null) {
            this.logging.message("  allow delete: " + (this.allow_delete ? "true" : "false"));
            this.logging.message("  allow insert: " + (this.allow_insert ? "true" : "false"));
            this.logging.message("  allow update: " + (this.allow_update ? "true" : "false"));
        }
    }

    public void printImportMode() {
        if (!this.allow_delete && this.allow_insert && !this.allow_update) {
            this.logging.message("importmode = insertonly");
        } else if (!this.allow_delete && this.allow_insert && this.allow_update) {
            this.logging.message("importmode = nodelete");
        } else if (this.allow_delete && this.allow_insert && !this.allow_update) {
            this.logging.message("importmode = noupdate");
        } else if (this.allow_delete && !this.allow_insert && !this.allow_update) {
            this.logging.message("importmode = deleteonly");
        } else {
            this.logging.message("importmode = default");
        }
        this.logging.message("  allow delete: " + (this.allow_delete ? "true" : "false"));
        this.logging.message("  allow insert: " + (this.allow_insert ? "true" : "false"));
        this.logging.message("  allow update: " + (this.allow_update ? "true" : "false"));
    }

    public static boolean performExport(String selectfile, JarSL jarsl, String connectparams) throws Exception {
        StringTokenizer st = new StringTokenizer(connectparams, ";");
        String driver = "dummy";
        String url = "dummy";
        String user = "dummy";
        String pass = "dummy";
        try {
            driver = st.nextToken();
            url = st.nextToken();
            user = st.nextToken();
            pass = st.nextToken();
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        DBTask dbtask = new DBTask(driver, url, user, pass);
        return dbtask.dbExport(selectfile, jarsl);
    }
}

