/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.dbaccess.FileLengthReader;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class ClobHandler
extends FieldHandler {
    ClobHandler(String name) {
        super(name, 2005);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        int len = this.read_length(jarsl);
        if (len >= 0) {
            char[] buffer = new char[len];
            int i = 0;
            while (i < len) {
                buffer[i] = jarsl.getCharData();
                ++i;
            }
            String sss = new String(buffer);
            stmt.setCharacterStream(columnNumber, (Reader)new StringReader(sss), sss.length());
        } else {
            this.initialize(stmt, columnNumber);
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        int len = this.read_length(jarsl);
        if (len < 0) {
            return "<NULL>";
        }
        char[] buffer = new char[len];
        int i = 0;
        while (i < len) {
            buffer[i] = jarsl.getCharData();
            ++i;
        }
        return new String(buffer);
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        stmt.setCharacterStream(columnNumber, (Reader)new StringReader(value), value.length());
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        this.setValue(stmt, columnNumber, "");
    }

    Clob getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getClob(columnNumber);
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        Clob clob = rs.getClob(columnNumber);
        if (clob != null) {
            long len = clob.length();
            if (len > Integer.MAX_VALUE) {
                throw new IOException("Length " + len + " too large, field " + this.name);
            }
            String buffer = clob.getSubString(1L, (int)len);
            jarsl.putIntData((int)clob.length());
            jarsl.putCharsData(buffer);
        } else {
            jarsl.putIntData(-1);
        }
    }

    private int read_length(JarSL jarsl) throws IOException {
        return FileLengthReader.getInstance().read_length(jarsl, this.bereadyforoldfile);
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

