/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.dbaccess.FileLengthReader;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class CharHandler
extends FieldHandler {
    CharHandler(String name) {
        super(name, 12);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        int len = this.read_length(jarsl);
        if (len < 0) {
            stmt.setNull(columnNumber, this.type);
        } else {
            char[] buffer = new char[len];
            int i = 0;
            while (i < len) {
                buffer[i] = jarsl.getCharData();
                ++i;
            }
            String newvalue = new String(buffer).trim();
            if (newvalue.length() == 0) {
                newvalue = " ";
            }
            stmt.setString(columnNumber, newvalue);
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        int len = this.read_length(jarsl);
        if (len < 0) {
            return "<NULL>";
        }
        char[] buffer = new char[len];
        int i = 0;
        while (i < len) {
            buffer[i] = jarsl.getCharData();
            ++i;
        }
        return new String(buffer);
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        int len = value.length();
        if (len < 0) {
            stmt.setNull(columnNumber, this.type);
        } else {
            String newvalue = value.trim();
            if (newvalue.length() == 0) {
                newvalue = " ";
            }
            stmt.setString(columnNumber, newvalue);
        }
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    String getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getString(columnNumber);
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        String s = rs.getString(columnNumber);
        if (s == null) {
            jarsl.putIntData(-1);
        } else {
            jarsl.putIntData(s.length());
            jarsl.putCharsData(s);
        }
    }

    private int read_length(JarSL jarsl) throws IOException {
        return FileLengthReader.getInstance().read_length(jarsl, this.bereadyforoldfile);
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

