/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.dbaccess.FileLengthReader;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class BinaryHandler
extends FieldHandler {
    protected int maxlen = 0;

    BinaryHandler(String name) {
        super(name, -2);
    }

    BinaryHandler(String name, int maxlen) {
        super(name, -2);
        this.maxlen = maxlen;
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        int length = this.read_length(jarsl);
        if (length >= 0) {
            byte[] bytes;
            if (length <= this.maxlen && this.maxlen > 0) {
                bytes = new byte[this.maxlen];
                jarsl.getData(bytes, 0, length);
            } else if (length <= this.maxlen || this.maxlen == 0) {
                bytes = new byte[length];
                jarsl.getData(bytes, 0, length);
            } else {
                bytes = new byte[this.maxlen];
                byte[] throwaway = new byte[length - this.maxlen];
                jarsl.getData(bytes, 0, this.maxlen);
                jarsl.getData(throwaway, 0, length - this.maxlen);
            }
            stmt.setBytes(columnNumber, bytes);
        } else {
            this.initialize(stmt, columnNumber);
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        int length = this.read_length(jarsl);
        if (length >= 0) {
            byte[] bytes = new byte[length];
            int readbytes = jarsl.getData(bytes, 0, length);
            String retval = "<" + length + " Bytes>";
            if (length > 0) {
                retval = retval + " (";
                int i = 0;
                while (i < length) {
                    retval = Character.isLetterOrDigit((char)bytes[i]) ? retval + (char)bytes[i] : retval + "#";
                    if (i == 50) {
                        retval = retval + "...";
                        break;
                    }
                    ++i;
                }
                retval = retval + ")";
            }
            return retval;
        }
        return "<null>";
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        stmt.setNull(columnNumber, this.type);
        throw new RuntimeException("BinaryHandler.setValue() is not implemented");
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    byte[] getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getBytes(columnNumber);
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(columnNumber);
        if (bytes == null) {
            jarsl.putIntData(-1);
        } else {
            jarsl.putIntData(bytes.length);
            jarsl.putData(bytes, 0, bytes.length);
        }
    }

    private int read_length(JarSL jarsl) throws IOException {
        return FileLengthReader.getInstance().read_length(jarsl, this.bereadyforoldfile);
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

