/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util;

import com.sap.sdm.util.Constants;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class StackTrace {
    private static final String VERSION_KEY = "java.version";
    private static final String JDK14_PREFIX = "1.4";
    private static boolean isJdkDetermined = false;
    private static boolean isJdk14 = false;

    public static String getStackTrace(Throwable t) {
        String stackTrace = "";
        if (t != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, false);
                StackTrace.printStackTrace(t, true, pw);
                pw.flush();
                sw.flush();
                stackTrace = sw.toString();
                pw.close();
                sw.close();
            }
            catch (IOException ioe) {
                stackTrace = t.toString();
            }
        }
        return stackTrace;
    }

    private static void printStackTrace(Throwable t, boolean first, PrintWriter pw) {
        if (t == null) {
            return;
        }
        if (!first) {
            pw.print(Constants.EOL + "Caused by: ");
        }
        t.printStackTrace(pw);
        if (StackTrace.runningOnJdk14()) {
            return;
        }
        StackTrace.printStackTrace(StackTrace.getCause(t), false, pw);
    }

    private static Throwable getCause(Throwable t) {
        if (t instanceof ClassNotFoundException) {
            return StackTrace.getCause((ClassNotFoundException)t);
        }
        if (t instanceof ExceptionInInitializerError) {
            return StackTrace.getCause((ExceptionInInitializerError)t);
        }
        if (t instanceof InvocationTargetException) {
            return StackTrace.getCause((InvocationTargetException)t);
        }
        if (t instanceof UndeclaredThrowableException) {
            return StackTrace.getCause((UndeclaredThrowableException)t);
        }
        return null;
    }

    private static Throwable getCause(ClassNotFoundException t) {
        return t.getException();
    }

    private static Throwable getCause(ExceptionInInitializerError t) {
        return t.getException();
    }

    private static Throwable getCause(InvocationTargetException t) {
        return t.getTargetException();
    }

    private static Throwable getCause(UndeclaredThrowableException t) {
        return t.getUndeclaredThrowable();
    }

    private static boolean runningOnJdk14() {
        if (!isJdkDetermined) {
            String version = System.getProperty(VERSION_KEY);
            if (version != null && version.startsWith(JDK14_PREFIX)) {
                isJdk14 = true;
            }
            isJdkDetermined = true;
        }
        return isJdk14;
    }

    private StackTrace() {
    }
}

