/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.diag;

import com.sap.sdm.diag.DiagMessage;
import com.sap.sdm.diag.SeverityConstants;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DiagException
extends Exception
implements SeverityConstants {
    private static final String MSG_INDENT = "    ";
    private static final List EMPTY_LIST = new LinkedList();
    private List childs = EMPTY_LIST;
    DiagMessage msg = null;
    String msgText = null;

    public DiagException() {
    }

    public DiagException(String msgID, String[] msgParams) {
        this(msgID, msgParams, null);
    }

    public DiagException(String msgText) {
        this(null, null, msgText);
    }

    private DiagException(String msgID, String[] msgParams, String msgText) {
        this();
        if (msgID != null) {
            this.setDiagMessage(new DiagMessage(msgID, msgParams));
            return;
        }
        if (msgText != null) {
            this.setMsgText(msgText);
            return;
        }
    }

    public void addChild(DiagException child) {
        if (child == null) {
            throw new Error("null");
        }
        if (this.childs == EMPTY_LIST) {
            this.childs = new LinkedList();
        }
        this.childs.add(child);
    }

    public Iterator getChilds() {
        return this.childs.iterator();
    }

    public void setDiagMessage(DiagMessage msg) {
        this.msg = msg;
    }

    public void setDiagMessage(String msgID) {
        this.msg = new DiagMessage();
        this.msg.setMsgID(msgID);
    }

    public void setDiagMessage(String msgID, String msgParam0) {
        this.setDiagMessage(msgID);
        this.msg.setMsgParams(msgParam0);
    }

    public void setDiagMessage(String msgID, String msgParam0, String msgParam1) {
        this.setDiagMessage(msgID);
        this.msg.setMsgParams(msgParam0, msgParam1);
    }

    public void setDiagMessage(String msgID, String[] msgParams) {
        this.setDiagMessage(msgID);
        this.msg.setMsgParams(msgParams);
    }

    public DiagMessage getDiagMessage() {
        return this.msg;
    }

    public void setMsgText(String msgText) {
        this.msgText = msgText;
    }

    public String getMsgText() {
        return this.msgText;
    }

    public String getMessage() {
        return this.getMessageChilds("");
    }

    String getMessageChilds(String indent) {
        String msg = "";
        if (this.getMsgText() != null) {
            msg = msg + indent + this.getMsgText() + "\n";
        }
        if (this.getDiagMessage() != null) {
            msg = msg + this.getDiagMessage().getMessage() + "\n";
        }
        String newIndent = msg.length() > 0 ? indent + MSG_INDENT : indent;
        Iterator it = this.getChilds();
        while (it.hasNext()) {
            msg = msg + ((DiagException)it.next()).getMessageChilds(newIndent);
        }
        return msg;
    }
}

