/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping.ccms;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.RuntimeParameters;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.TraceFormatter;
import java.io.File;
import java.lang.reflect.Method;

public class Trace {
    private static final String PACKAGE_NAME = Trace.getPackageName(class$com$sap$engine$library$monitor$mapping$ccms$Trace == null ? (class$com$sap$engine$library$monitor$mapping$ccms$Trace = Trace.class$("com.sap.engine.library.monitor.mapping.ccms.Trace")) : class$com$sap$engine$library$monitor$mapping$ccms$Trace);
    private static final Location topLoc = Location.getLocation((String)PACKAGE_NAME);
    private static final Location loc = Location.getLocation((Class)(class$com$sap$engine$library$monitor$mapping$ccms$Trace == null ? (class$com$sap$engine$library$monitor$mapping$ccms$Trace = Trace.class$("com.sap.engine.library.monitor.mapping.ccms.Trace")) : class$com$sap$engine$library$monitor$mapping$ccms$Trace));
    private RuntimeParameters params = null;
    private FileLog fLog = null;
    static /* synthetic */ Class class$com$sap$engine$library$monitor$mapping$ccms$Trace;

    private static final String getPackageName(Class c) {
        String name = c.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            return name.substring(0, i);
        }
        return null;
    }

    public Trace(RuntimeParameters params) {
        this.params = params;
        this.archiveTrace();
        this.fLog = new FileLog(params.getTraceFileName());
        this.fLog.setFormatter((Formatter)new TraceFormatter());
        topLoc.addLog((Log)this.fLog);
        topLoc.setEffectiveSeverity(0);
        String system = params.isSystemMode() ? "(System)" : " (Host) ";
        loc.infoT("************************************************************");
        loc.infoT("**************     CCMS CONNECTOR " + system + "    **************");
        loc.infoT("************************************************************");
        loc.infoT("Tracelevel: " + params.getTracelevel());
        topLoc.setEffectiveSeverity(params.getTracelevel() <= 0 ? 500 : (params.getTracelevel() == 1 ? 400 : (params.getTracelevel() == 2 ? 300 : 0)));
    }

    private void archiveTrace() {
        try {
            File file = new File(this.params.getTraceFileName());
            if (file.exists()) {
                File oldFile = new File(this.params.getTraceFileName() + ".old");
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                file.renameTo(oldFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void print(String message, IMonitorNode j2eeNode, Throwable t, boolean error) {
        this.print(message + (j2eeNode == null ? "" : "<" + j2eeNode.getPath() + ">") + ": " + t.toString(), t, error);
    }

    public void print(String message, Throwable t, boolean error) {
        if (error) {
            loc.errorT(message);
        } else {
            loc.warningT(message);
        }
        this.printRootCauseStack(t);
    }

    public void close() {
        this.fLog.close();
        this.fLog = null;
        this.params = null;
    }

    private void printRootCauseStack(Throwable t) {
        if (this.params.getTracelevel() > 3) {
            try {
                Method method = t.getClass().getMethod("getOriginal", null);
                loc.catching((Throwable)method.invoke((Object)t, null));
            }
            catch (Throwable t1) {
                loc.catching(t);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

