/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping.ccms;

import com.sap.mona.api.TextAttribute;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;

class TableAttribute {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$engine$library$monitor$mapping$ccms$TableAttribute == null ? (class$com$sap$engine$library$monitor$mapping$ccms$TableAttribute = TableAttribute.class$("com.sap.engine.library.monitor.mapping.ccms.TableAttribute")) : class$com$sap$engine$library$monitor$mapping$ccms$TableAttribute));
    private static final int ONE_MINUTE = 60000;
    private static final String COLUMN_SEPARATOR = ";";
    private static final String ROW_SEPARATOR = "|";
    private static final String LEGEND = "ColumnSeparator:; RowSeparator:|\n";
    private TextAttribute ccmsNode;
    private File file;
    private long lastReported = 0L;
    private boolean dirty = false;
    static /* synthetic */ Class class$com$sap$engine$library$monitor$mapping$ccms$TableAttribute;

    public TableAttribute(TextAttribute ccmsNode, File file) {
        this.ccmsNode = ccmsNode;
        this.file = file;
    }

    public TextAttribute getCcmsNode() {
        return this.ccmsNode;
    }

    public synchronized void writeTableToFileForced(Serializable[] tableHeader, Serializable[][] tableEntries) {
        if (this.dirty) {
            this.flush(tableHeader, tableEntries);
        }
    }

    public synchronized void writeTableToFile(long timestamp, Serializable[] tableHeader, Serializable[][] tableEntries) {
        if (this.dirty && timestamp - this.lastReported > 60000L) {
            this.flush(tableHeader, tableEntries);
        }
    }

    public synchronized void writeTableToFile(Serializable[] tableHeader, Serializable[][] tableEntries) {
        if (this.lastReported == 0L || System.currentTimeMillis() - this.lastReported > 60000L) {
            this.flush(tableHeader, tableEntries);
        } else {
            this.dirty = true;
        }
    }

    private void flush(Serializable[] tableHeader, Serializable[][] tableEntries) {
        StringBuffer content = new StringBuffer(LEGEND);
        int headerColumns = tableHeader.length;
        int tableRows = tableEntries.length;
        int i = 0;
        while (i < headerColumns) {
            content.append(tableHeader[i]);
            content.append(i == headerColumns - 1 ? ROW_SEPARATOR : COLUMN_SEPARATOR);
            ++i;
        }
        int j = 0;
        while (j < tableRows) {
            int tableColumns = tableEntries[j].length;
            int i2 = 0;
            while (i2 < tableColumns) {
                content.append(tableEntries[j][i2]);
                content.append(i2 == tableColumns - 1 ? ROW_SEPARATOR : COLUMN_SEPARATOR);
                ++i2;
            }
            ++j;
        }
        try {
            PrintStream out = new PrintStream(new FileOutputStream(this.file));
            out.println(content.toString());
            out.close();
        }
        catch (IOException e) {
            loc.warningT("flush: " + e.toString());
        }
        content = null;
        this.dirty = false;
        this.lastReported = System.currentTimeMillis();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

