/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping.ccms;

import com.sap.engine.library.monitor.mapping.ccms.RuntimeParameters;
import com.sap.mona.api.AlertValue;
import com.sap.mona.api.AnalysisMethod;
import com.sap.mona.api.LogCacheAttribute;
import com.sap.mona.api.LogProperties;
import com.sap.mona.api.MethodSet;
import com.sap.mona.api.MonitoringNode;
import com.sap.mona.api.MonitoringNodeProperties;
import com.sap.mona.api.NodeFactory;
import com.sap.mona.api.NodeNotExistingException;
import com.sap.mona.api.ObjectNode;
import com.sap.mona.api.RootNode;
import com.sap.mona.api.StatusLineAttribute;
import com.sap.mona.api.StatusProperties;
import com.sap.mona.api.XMIMessage;
import com.sap.tc.logging.Location;
import java.io.File;

public class Selfmonitoring {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$engine$library$monitor$mapping$ccms$Selfmonitoring == null ? (class$com$sap$engine$library$monitor$mapping$ccms$Selfmonitoring = Selfmonitoring.class$("com.sap.engine.library.monitor.mapping.ccms.Selfmonitoring")) : class$com$sap$engine$library$monitor$mapping$ccms$Selfmonitoring));
    private static final String ANALYSIS_SHOW_FILE = "CCMS_SHOW_FILE_FROM_TEXT_ATTR";
    private StatusLineAttribute connectorMoniSegment;
    private StatusLineAttribute connectorMoniIncompat;
    private LogCacheAttribute connectorMoniMapping;
    private RuntimeParameters params;
    static /* synthetic */ Class class$com$sap$engine$library$monitor$mapping$ccms$Selfmonitoring;

    public Selfmonitoring(RuntimeParameters params) {
        this.params = params;
        try {
            this.createSelfMonitoringNodes();
        }
        catch (Throwable t) {
            loc.errorT("Couldn't create self monitoring (" + t.getMessage() + ").");
        }
    }

    public void reportOutOfMemory(String message) {
        try {
            try {
                this.connectorMoniSegment.update();
            }
            catch (NodeNotExistingException e) {
                this.createSelfMonitoringNodes();
            }
            AlertValue value = this.connectorMoniSegment.getCurrentValue();
            if (value == null || value.equals((Object)AlertValue.GREEN)) {
                this.connectorMoniSegment.report(AlertValue.RED, message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void reportIncompatibility(String message) {
        try {
            try {
                this.connectorMoniIncompat.update();
            }
            catch (NodeNotExistingException e) {
                this.createSelfMonitoringNodes();
            }
            AlertValue value = this.connectorMoniIncompat.getCurrentValue();
            if (value == null || value.equals((Object)AlertValue.GREEN)) {
                this.connectorMoniIncompat.report(AlertValue.RED, message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void reportInvalidUniqueName(String message) {
        try {
            try {
                this.connectorMoniMapping.update();
            }
            catch (NodeNotExistingException e) {
                this.createSelfMonitoringNodes();
            }
            this.connectorMoniMapping.report(AlertValue.RED, 50, message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createSelfMonitoringNodes() {
        RootNode selfMoni = NodeFactory.getSelfMonitoringNode();
        ObjectNode connectorMoni = NodeFactory.createObjectNode((MonitoringNode)selfMoni, (String)"CCMS Connector", (XMIMessage)new XMIMessage("SAP J2EE Engine", "SelfM_CCMS_Connector_Help"), (MonitoringNodeProperties)new MonitoringNodeProperties("SelfM_CCMS_Connector"));
        this.connectorMoniSegment = NodeFactory.createStatusLineAttribute((MonitoringNode)connectorMoni, (String)("Shared memory segment " + (this.params.isSystemMode() ? new Integer(this.params.getJ2eeInstanceNumber()).toString() : new Integer(99).toString())), (XMIMessage)new XMIMessage("SAP J2EE Engine", "SelfM_CCMS_Shm_Help"), (StatusProperties)new StatusProperties("SelfM_CCMS_Shm"));
        AlertValue value = this.connectorMoniSegment.getCurrentValue();
        if (value == null || value.equals((Object)AlertValue.GREEN)) {
            this.connectorMoniSegment.report(AlertValue.GREEN, "No problems detected.");
        }
        this.connectorMoniIncompat = NodeFactory.createStatusLineAttribute((MonitoringNode)connectorMoni, (String)"Incompatible monitoring nodes", (XMIMessage)new XMIMessage("SAP J2EE Engine", "SelfM_CCMS_Incom_Help"), (StatusProperties)new StatusProperties("SelfM_CCMS_Incom"));
        value = this.connectorMoniIncompat.getCurrentValue();
        if (value == null || value.equals((Object)AlertValue.GREEN)) {
            this.connectorMoniIncompat.report(AlertValue.GREEN, "No problems detected.");
        }
        this.connectorMoniMapping = NodeFactory.createLogCacheAttribute((MonitoringNode)connectorMoni, (String)"Mapping errors", (XMIMessage)new XMIMessage("SAP J2EE Engine", "SelfM_CCMS_Map_help"), (LogProperties)new LogProperties("SelfM_CCMS_Map"));
        NodeFactory.createTextAttribute((MonitoringNode)connectorMoni, (String)(this.params.getJ2eeNodeNumber() + " JMon Trace"), (XMIMessage)new XMIMessage("SAP J2EE Engine", "Trace_JMon_Help"), (String)(this.params.getTraceDirectory() + File.separator + "ccms_jmon.trc"), (MonitoringNodeProperties)new MonitoringNodeProperties("Trace_JMon", new MethodSet(new AnalysisMethod(ANALYSIS_SHOW_FILE))));
        NodeFactory.createTextAttribute((MonitoringNode)connectorMoni, (String)(this.params.getJ2eeNodeNumber() + " Connector Trace"), (XMIMessage)new XMIMessage("SAP J2EE Engine", "Trace_CCMS_Connector_Help"), (String)(this.params.getTraceDirectory() + File.separator + "ccms_connector.trc"), (MonitoringNodeProperties)new MonitoringNodeProperties("Trace_CCMS_Connector", new MethodSet(new AnalysisMethod(ANALYSIS_SHOW_FILE))));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

