/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping.ccms;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class RuntimeParameters {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$engine$library$monitor$mapping$ccms$RuntimeParameters == null ? (class$com$sap$engine$library$monitor$mapping$ccms$RuntimeParameters = RuntimeParameters.class$("com.sap.engine.library.monitor.mapping.ccms.RuntimeParameters")) : class$com$sap$engine$library$monitor$mapping$ccms$RuntimeParameters));
    private String sid;
    private String j2eeInstanceNumber;
    private int j2eeNodeNumber;
    private boolean j2eeDispatcher;
    private String j2eeProfile;
    private String tableDirectory;
    private Date startUpTime;
    private boolean systemMode;
    private int tracelevel;
    private String traceFileName;
    private String traceDirectory;
    static /* synthetic */ Class class$com$sap$engine$library$monitor$mapping$ccms$RuntimeParameters;

    public RuntimeParameters(String sid, int j2eeInstanceNumber, int j2eeNodeNumber, boolean j2eeDispatcher, String j2eeProfile, String dirCcms, Date startUpTime, boolean systemMode, int tracelevel) {
        this.sid = sid;
        this.j2eeNodeNumber = j2eeNodeNumber;
        this.j2eeDispatcher = j2eeDispatcher;
        this.j2eeProfile = j2eeProfile;
        this.startUpTime = startUpTime;
        this.systemMode = systemMode;
        this.tracelevel = tracelevel;
        this.j2eeInstanceNumber = this.formatInstanceNumber(j2eeInstanceNumber);
        this.tableDirectory = this.determineTableDirectory(dirCcms, this.sid, this.j2eeInstanceNumber, this.j2eeNodeNumber);
        this.traceFileName = this.determineTraceFileName(this.tableDirectory);
        this.traceDirectory = this.determineTraceDirectory(this.traceFileName, this.tableDirectory);
    }

    public final boolean isJ2eeDispatcher() {
        return this.j2eeDispatcher;
    }

    public final String getJ2eeInstanceNumber() {
        return this.j2eeInstanceNumber;
    }

    public final int getJ2eeNodeNumber() {
        return this.j2eeNodeNumber;
    }

    public final String getJ2eeProfile() {
        return this.j2eeProfile;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Date getStartUpTime() {
        return this.startUpTime;
    }

    public final boolean isSystemMode() {
        return this.systemMode;
    }

    public final String getTableDirectory() {
        return this.tableDirectory;
    }

    public final String getTraceDirectory() {
        return this.traceDirectory;
    }

    public final int getTracelevel() {
        return this.tracelevel;
    }

    public final String getTraceFileName() {
        return this.traceFileName;
    }

    private String formatInstanceNumber(int j2eeInstNumber) {
        return j2eeInstNumber > 98 || j2eeInstNumber < 0 ? "??" : (j2eeInstNumber < 10 ? "0" + j2eeInstNumber : "" + j2eeInstNumber);
    }

    private String determineTraceFileName(String tableDir) {
        return tableDir == null ? "ccms_connector.trc" : tableDir + "ccms_connector.trc";
    }

    private String determineTraceDirectory(String trcFileName, String tableDir) {
        try {
            File file = new File(trcFileName);
            String traceDir = file.getCanonicalPath();
            return traceDir.substring(0, traceDir.lastIndexOf(File.separator));
        }
        catch (IOException e) {
            return tableDir;
        }
    }

    private String determineTableDirectory(String dirCcms, String sysId, String j2eeInstNum, int j2eeNodeNum) {
        String dirName = dirCcms + File.separator + sysId + "_" + j2eeInstNum + File.separator + "j2ee" + j2eeNodeNum;
        try {
            File j2eeDirectory = new File(dirName);
            if (!j2eeDirectory.exists() && !j2eeDirectory.mkdirs()) {
                throw new Throwable();
            }
            return j2eeDirectory.getPath() + File.separator;
        }
        catch (Throwable t) {
            loc.errorT("Can't create CCMS connector directory (" + dirName + "). Check file system permissions.");
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

