/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping.ccms;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.TableAttribute;
import com.sap.mona.api.MonitoringNode;
import com.sap.mona.api.NodeFactory;
import com.sap.mona.api.NodeNotExistingException;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Registry {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$engine$library$monitor$mapping$ccms$Registry == null ? (class$com$sap$engine$library$monitor$mapping$ccms$Registry = Registry.class$("com.sap.engine.library.monitor.mapping.ccms.Registry")) : class$com$sap$engine$library$monitor$mapping$ccms$Registry));
    private static final String APP_REG_FILENAME = "applications.xml";
    private static final String ROOT_TAG = "apps";
    private static final String ROOT_TAG_BEGIN = "<apps>\n";
    private static final String ROOT_TAG_END = "</apps>";
    private static final String APP_TAG = "app";
    private static final String APP_NAME_ATTR = "name";
    private static final String APP_TAG_BEGIN = "  <app name=\"";
    private static final String APP_TAG_END = "  </app>\n";
    private static final String NODE_TAG = "node";
    private static final String NODE_TAG_BEGIN = "    <node>";
    private static final String NODE_TAG_END = "</node>\n";
    private Hashtable mapableNodes = new Hashtable();
    private HashSet invalidNodes = new HashSet();
    private Hashtable applications = new Hashtable();
    private HashSet tableNodeBuffer = new HashSet();
    private File appRegFile = null;
    static /* synthetic */ Class class$com$sap$engine$library$monitor$mapping$ccms$Registry;

    public Registry(String dir) {
        if (dir != null) {
            this.appRegFile = new File(dir + File.separator + APP_REG_FILENAME);
            this.initializeAppRegistry();
        }
    }

    public final void addValid(IMonitorNode j2eeNode, Object mapNode) {
        this.invalidNodes.remove(j2eeNode);
        this.mapableNodes.put(j2eeNode, mapNode);
        if (this.isTableNode(j2eeNode)) {
            this.tableNodeBuffer.add(j2eeNode);
        }
        String application = j2eeNode.getOwner();
        if (this.isApplicationTopNode(j2eeNode)) {
            MonitoringNode ccmsNode = (MonitoringNode)mapNode;
            if (this.applications.containsKey(application)) {
                HashSet nodes = (HashSet)this.applications.get(application);
                if (!nodes.contains(ccmsNode.getLongName())) {
                    nodes.add(ccmsNode.getLongName());
                    this.persistAppRegistry();
                }
            } else {
                HashSet<String> nodes = new HashSet<String>();
                nodes.add(ccmsNode.getLongName());
                this.applications.put(application, nodes);
                this.persistAppRegistry();
            }
        }
    }

    public final void addInvalid(IMonitorNode j2eeNode) {
        this.mapableNodes.remove(j2eeNode);
        this.invalidNodes.add(j2eeNode);
        this.tableNodeBuffer.remove(j2eeNode);
    }

    public final void remove(String application) {
        if (this.applications.containsKey(application)) {
            Iterator nodes = ((HashSet)this.applications.get(application)).iterator();
            while (nodes.hasNext()) {
                String longName = (String)nodes.next();
                try {
                    MonitoringNode ccmsNode = NodeFactory.getMonitoringNode((String)longName);
                    NodeFactory.deleteNode((MonitoringNode)ccmsNode);
                }
                catch (Exception e) {
                    loc.warningT("remove(String): " + e.toString());
                }
            }
            this.applications.remove(application);
            this.persistAppRegistry();
        }
    }

    public final void remove(IMonitorNode j2eeNode, boolean persistent) {
        if (this.isTableNode(j2eeNode)) {
            TableAttribute tableNode = (TableAttribute)this.mapableNodes.get(j2eeNode);
            if (tableNode != null) {
                tableNode.writeTableToFileForced(((ITableMonitorNode)j2eeNode).getHeader(), ((ITableMonitorNode)j2eeNode).getEntries());
            }
            this.tableNodeBuffer.remove(j2eeNode);
        }
        if (persistent) {
            String application;
            Vector ccmsNodes = this.getCcmsNodes(this.mapableNodes.get(j2eeNode));
            if (this.isApplicationTopNode(j2eeNode) && this.applications.containsKey(application = j2eeNode.getOwner())) {
                try {
                    String longName = ((MonitoringNode)ccmsNodes.firstElement()).getLongName();
                    HashSet nodes = (HashSet)this.applications.get(application);
                    if (nodes.contains(longName)) {
                        nodes.remove(longName);
                        if (nodes.isEmpty()) {
                            this.applications.remove(application);
                        }
                        this.persistAppRegistry();
                    }
                }
                catch (Exception e) {
                    loc.warningT("remove(IMonitorNode, boolean): " + e.toString());
                }
            }
            Iterator iter = ((AbstractList)ccmsNodes).iterator();
            while (iter.hasNext()) {
                MonitoringNode ccmsNode = (MonitoringNode)iter.next();
                try {
                    NodeFactory.deleteNode((MonitoringNode)ccmsNode);
                }
                catch (Exception e) {
                    loc.warningT("remove(IMonitorNode, boolean): " + e.toString());
                }
            }
        }
        this.mapableNodes.remove(j2eeNode);
        this.invalidNodes.remove(j2eeNode);
    }

    public final Object get(IMonitorNode j2eeNode) {
        return this.mapableNodes.get(j2eeNode);
    }

    public final Iterator getTableNodes() {
        return this.tableNodeBuffer.iterator();
    }

    public final boolean isInvalid(IMonitorNode j2eeNode) {
        return this.invalidNodes.contains(j2eeNode);
    }

    public final void cleanUp() {
        this.mapableNodes = null;
        this.invalidNodes = null;
        this.applications = null;
        this.tableNodeBuffer = null;
        this.appRegFile = null;
    }

    private void initializeAppRegistry() {
        try {
            FileInputStream inStream = new FileInputStream(this.appRegFile);
            StandardDOMParser parser = new StandardDOMParser();
            Document document = parser.parse((InputStream)inStream);
            boolean modified = false;
            NodeList apps = document.getElementsByTagName(APP_TAG);
            int i = 0;
            while (i < apps.getLength()) {
                Element app = (Element)apps.item(i);
                NodeList nodes = app.getElementsByTagName(NODE_TAG);
                HashSet<String> allNodes = new HashSet<String>();
                int j = 0;
                while (j < nodes.getLength()) {
                    Element node = (Element)nodes.item(j);
                    String longName = node.getFirstChild().getNodeValue();
                    if (this.existsInShm(longName)) {
                        allNodes.add(longName);
                    } else {
                        modified = true;
                    }
                    ++j;
                }
                if (!allNodes.isEmpty()) {
                    this.applications.put(app.getAttribute(APP_NAME_ATTR), allNodes);
                }
                ++i;
            }
            ((InputStream)inStream).close();
            if (modified) {
                this.persistAppRegistry();
            }
        }
        catch (Exception e) {
            loc.warningT("initializeAppRegistry: " + e.toString());
        }
    }

    private void persistAppRegistry() {
        StringBuffer content = new StringBuffer(ROOT_TAG_BEGIN);
        Iterator entries = this.applications.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            String app = (String)element.getKey();
            content.append(APP_TAG_BEGIN).append(app).append("\">\n");
            Iterator allNodes = ((HashSet)element.getValue()).iterator();
            while (allNodes.hasNext()) {
                String node = (String)allNodes.next();
                content.append(NODE_TAG_BEGIN).append(node).append(NODE_TAG_END);
            }
            content.append(APP_TAG_END);
        }
        content.append(ROOT_TAG_END);
        try {
            PrintStream outStream = new PrintStream(new FileOutputStream(this.appRegFile));
            outStream.println(content.toString());
            outStream.close();
        }
        catch (Exception e) {
            loc.warningT("persistAppRegistry: " + e.toString());
        }
    }

    private boolean existsInShm(String longName) {
        try {
            NodeFactory.getMonitoringNode((String)longName);
            return true;
        }
        catch (NodeNotExistingException e) {
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private boolean isApplicationTopNode(IMonitorNode j2eeNode) {
        return j2eeNode.getTyp() == 0 && j2eeNode.getOwner() != null && j2eeNode.getOwner().length() > 0 && j2eeNode.getParent() != null && j2eeNode.getParent().getPath().equals("/Applications");
    }

    private boolean isTableNode(IMonitorNode j2eeNode) {
        return j2eeNode.getTyp() == 7 && !j2eeNode.getPath().equals("/System/System Properties");
    }

    private Vector getCcmsNodes(Object node) {
        Vector<Object> result = new Vector<Object>();
        if (node != null) {
            if (node instanceof MonitoringNode) {
                result.add((MonitoringNode)node);
            } else if (node instanceof TableAttribute) {
                result.add(((TableAttribute)node).getCcmsNode());
            } else {
                if (node instanceof Vector) {
                    return (Vector)node;
                }
                loc.errorT("getCcmsNodes: Invalid type (" + node.getClass().getName() + ").");
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

