/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping.ccms;

import com.sap.engine.library.monitor.ICommonStateMonitorNode;
import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IObjectMonitorNode;
import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.ISummaryMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.mapping.ccms.AvailabilityException;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnectorAPI;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnectorException;
import com.sap.engine.library.monitor.mapping.ccms.CcmsMapException;
import com.sap.engine.library.monitor.mapping.ccms.CcmsReportingException;
import com.sap.engine.library.monitor.mapping.ccms.Registry;
import com.sap.engine.library.monitor.mapping.ccms.RuntimeParameters;
import com.sap.engine.library.monitor.mapping.ccms.Selfmonitoring;
import com.sap.engine.library.monitor.mapping.ccms.TableAttribute;
import com.sap.engine.library.monitor.mapping.ccms.Trace;
import com.sap.mona.api.AlertValue;
import com.sap.mona.api.AnalysisMethod;
import com.sap.mona.api.AttributeNodeProperties;
import com.sap.mona.api.AutoReactionMethod;
import com.sap.mona.api.ExceedThresholds;
import com.sap.mona.api.FallbelowThresholds;
import com.sap.mona.api.IncompatibilityException;
import com.sap.mona.api.InvalidUniqueNameException;
import com.sap.mona.api.JMonException;
import com.sap.mona.api.MethodSet;
import com.sap.mona.api.MonitoringAgent;
import com.sap.mona.api.MonitoringNode;
import com.sap.mona.api.MonitoringNodeProperties;
import com.sap.mona.api.NoMoreSpaceException;
import com.sap.mona.api.NodeFactory;
import com.sap.mona.api.NodeNotExistingException;
import com.sap.mona.api.ObjectNode;
import com.sap.mona.api.PerfValueAttribute;
import com.sap.mona.api.PerformanceAttribute;
import com.sap.mona.api.PerformanceProperties;
import com.sap.mona.api.StatusAttribute;
import com.sap.mona.api.StatusLineAttribute;
import com.sap.mona.api.StatusProperties;
import com.sap.mona.api.T100Message;
import com.sap.mona.api.TextAttribute;
import com.sap.mona.api.Thresholds;
import com.sap.mona.api.XMIMessage;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public final class CcmsConnector
implements CcmsConnectorAPI {
    private static final String CONTEXT_OWNER = "SAP CCMS Connector";
    private static final String PROPERTIES_SEPARATOR = "|";
    private static final String PATH_SEPARATOR = "/";
    private static final String ANALYSIS_SHOW_TABLE = "CCMS_SHOW_FILE_FROM_TEXT_ATTR_IN_GRID";
    protected static final String XMI_MESSAGE_CLASS = "SAP J2EE Engine";
    protected static final String ENGINE_PATH = "/";
    protected static final String APPLICATIONS_PATH = "/Applications";
    protected static final String SYSTEM_PROPS_PATH = "/System/System Properties";
    private static final int ROOT_NODE = 100;
    private static final int SUMMARY_NODE = 101;
    private static final int OBJECT_NODE = 102;
    private static final int TEXT_ATTRIBUTE = 200;
    private static final int TABLE_ATTRIBUTE = 201;
    private static final int PERF_VALUE_ATTRIBUTE = 300;
    private static final int PERF_FREQ_ATTRIBUTE = 301;
    private static final int PERF_COUNTER_ATTRIBUTE = 302;
    private static final int PERF_COUNTER_SEC_ATTRIBUTE = 303;
    private static final int PERF_QUALITY_ATTRIBUTE = 304;
    private static final int PERF_AVAIL_ATTRIBUTE = 305;
    private static final int PERF_OCCUP_ATTRIBUTE = 306;
    private static final int PERF_OCCUP_DIFF_ATTRIBUTE = 307;
    private static final int STATUS_LINE_ATTRIBUTE = 400;
    private static final int STATUS_EXP_ATTRIBUTE = 401;
    private static final int LOG_CACHE_ATTRIBUTE = 500;
    private static final int TEXT_ATTRIBUTE_SET = 600;
    protected static final String CON_TRACE_FILE_NAME = "ccms_connector.trc";
    protected static final String JMON_TRACE_FILE_NAME = "ccms_jmon.trc";
    private static final Location loc = Location.getLocation((Class)(class$com$sap$engine$library$monitor$mapping$ccms$CcmsConnector == null ? (class$com$sap$engine$library$monitor$mapping$ccms$CcmsConnector = CcmsConnector.class$("com.sap.engine.library.monitor.mapping.ccms.CcmsConnector")) : class$com$sap$engine$library$monitor$mapping$ccms$CcmsConnector));
    private static CcmsConnector instance = null;
    private Registry registry = null;
    private RuntimeParameters params = null;
    private Selfmonitoring selfMonitoring = null;
    private Trace trace = null;
    static /* synthetic */ Class class$com$sap$engine$library$monitor$mapping$ccms$CcmsConnector;

    private CcmsConnector(String sid, int j2eeInstanceNumber, int j2eeNodeNumber, boolean j2eeDispatcher, String j2eeProfile, String dirCcms, int tracelevel, boolean systemMode) throws AvailabilityException {
        this.params = new RuntimeParameters(sid, j2eeInstanceNumber, j2eeNodeNumber, j2eeDispatcher, j2eeProfile, dirCcms, new Date(), systemMode, tracelevel);
        this.trace = new Trace(this.params);
        loc.infoT("CcmsConnector ({0}, {1})", new Object[]{sid, this.params.getJ2eeInstanceNumber()});
        if (loc.beDebug()) {
            loc.debugT("  J2eeNodeNumber: {0}", new Object[]{new Integer(j2eeNodeNumber)});
            loc.debugT("  J2eeDispatcher: {0}", new Object[]{new Boolean(j2eeDispatcher)});
            loc.debugT("  J2eeProfile: {0}", new Object[]{j2eeProfile});
            loc.debugT("  DirCcms:        {0}", new Object[]{dirCcms});
            loc.debugT("  Tracelevel:     {0}", new Object[]{new Integer(tracelevel)});
            loc.debugT("  SystemMode:     {0}", new Object[]{new Boolean(systemMode)});
            if (tracelevel > 4) {
                loc.catching(new Throwable());
            }
        }
        this.connect2Ccms();
        this.registry = new Registry(this.params.getTableDirectory());
        this.selfMonitoring = new Selfmonitoring(this.params);
    }

    public static final CcmsConnector createInstance(String sid, int j2eeInstanceNumber, int j2eeNodeNumber, boolean j2eeDispatcher, String j2eeProfile, String dirCcms, int tracelevel, boolean systemMode) throws CcmsConnectorException, AvailabilityException {
        if (instance == null) {
            instance = new CcmsConnector(sid, j2eeInstanceNumber, j2eeNodeNumber, j2eeDispatcher, j2eeProfile, dirCcms, tracelevel, systemMode);
        }
        return instance;
    }

    public static final CcmsConnector getInstance() {
        return instance;
    }

    public static final void removeInstance() throws CcmsConnectorException {
        if (instance == null) {
            return;
        }
        instance.finalCleanUp();
        instance = null;
        try {
            MonitoringAgent.disconnect();
        }
        catch (Throwable t) {
            throw new CcmsConnectorException("Could not detach from shared memory (" + t.getMessage() + ").", t);
        }
    }

    private void connect2Ccms() throws AvailabilityException {
        Properties systemProperties = System.getProperties();
        if (!this.params.isSystemMode()) {
            ((Hashtable)systemProperties).put("sap.jmon.nosystem", "true");
        } else if (this.params.getJ2eeProfile() != null) {
            ((Hashtable)systemProperties).put("sapccmsr.profile", this.params.getJ2eeProfile());
        }
        if (this.params.getTableDirectory() != null) {
            ((Hashtable)systemProperties).put("sap.jmon.trcfile", this.params.getTableDirectory() + JMON_TRACE_FILE_NAME);
        }
        if (this.params.getTracelevel() >= 0) {
            String trace = this.params.getTracelevel() < 3 ? new Integer(this.params.getTracelevel()).toString() : "3";
            ((Hashtable)systemProperties).put("sap.jmon.jtrclevel", trace);
            ((Hashtable)systemProperties).put("sap.jmon.ctrclevel", trace);
        }
        try {
            block11: {
                try {
                    if (MonitoringAgent.isConnected()) {
                        if (!this.params.isSystemMode() && MonitoringAgent.getConnection() != 99 || this.params.isSystemMode() && MonitoringAgent.getConnection() != Integer.parseInt(this.params.getJ2eeInstanceNumber())) {
                            throw new CcmsConnectorException("Already attached to a different shared memory segment.");
                        }
                        loc.infoT("Already attached to shared memory.");
                        break block11;
                    }
                    MonitoringAgent.connect((String)"CCMS Connector");
                }
                catch (Throwable t) {
                    throw new AvailabilityException("Could not attach to shared memory (" + t.getMessage() + ").", t);
                }
            }
            Object var4_4 = null;
            ((Hashtable)systemProperties).remove("sap.jmon.trcfile");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((Hashtable)systemProperties).remove("sap.jmon.trcfile");
            ((Hashtable)systemProperties).remove("sap.jmon.jtrclevel");
            ((Hashtable)systemProperties).remove("sap.jmon.ctrclevel");
            ((Hashtable)systemProperties).remove("sap.jmon.nosystem");
            ((Hashtable)systemProperties).remove("sapccmsr.profile");
            throw throwable;
        }
        ((Hashtable)systemProperties).remove("sap.jmon.jtrclevel");
        ((Hashtable)systemProperties).remove("sap.jmon.ctrclevel");
        ((Hashtable)systemProperties).remove("sap.jmon.nosystem");
        ((Hashtable)systemProperties).remove("sapccmsr.profile");
    }

    public void triggerCyclicTasks() {
        long currentTimestamp = System.currentTimeMillis();
        Iterator iter = this.registry.getTableNodes();
        while (iter.hasNext()) {
            ITableMonitorNode jTableNode = (ITableMonitorNode)iter.next();
            TableAttribute cTableNode = (TableAttribute)this.registry.get(jTableNode);
            if (cTableNode == null) continue;
            cTableNode.writeTableToFile(currentTimestamp, jTableNode.getHeader(), jTableNode.getEntries());
        }
    }

    private StatusAttribute createStatusAttribute(ObjectNode ccmsParent, int ccmsNodeType, ICommonStateMonitorNode j2eeNode) throws CcmsConnectorException, JMonException {
        String name = j2eeNode.getName();
        String mteClass = j2eeNode.getConfigurationGroup();
        XMIMessage description = this.getDescription(j2eeNode);
        MethodSet methods = this.getMethods(j2eeNode, null);
        StatusProperties ccmsProperties = new StatusProperties(mteClass, methods);
        int alertMode = j2eeNode.getAlertMode();
        ccmsProperties.setAlertMode((byte)alertMode);
        this.setDataCollectionTime(j2eeNode, (AttributeNodeProperties)ccmsProperties);
        switch (ccmsNodeType) {
            case 400: {
                return NodeFactory.createStatusLineAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (StatusProperties)ccmsProperties);
            }
            case 401: {
                return NodeFactory.createStatusExpAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (StatusProperties)ccmsProperties);
            }
        }
        throw new CcmsConnectorException("Unknown CCMS status type.", true);
    }

    private PerformanceAttribute createPerformanceAttribute(ObjectNode ccmsParent, int ccmsNodeType, IPerformanceMonitorNode j2eeNode) throws CcmsConnectorException, JMonException {
        String name = j2eeNode.getName();
        String mteClass = j2eeNode.getConfigurationGroup();
        XMIMessage description = this.getDescription(j2eeNode);
        Thresholds thresholds = this.getThresholds(j2eeNode);
        String unit = j2eeNode.getUnit();
        MethodSet methods = this.getMethods(j2eeNode, null);
        PerformanceProperties ccmsProperties = new PerformanceProperties(mteClass, methods, thresholds, unit);
        int relevantValue = this.getAlertRelevantValueType(j2eeNode, ccmsNodeType);
        ccmsProperties.setRelevantValueType((byte)relevantValue);
        this.setDataCollectionTime(j2eeNode, (AttributeNodeProperties)ccmsProperties);
        if (j2eeNode instanceof IFrequencyMonitorNode) {
            ccmsProperties.setDecimals(2);
        }
        if (loc.beDebug()) {
            loc.debugT("  Unit:                             {0}", new Object[]{unit});
            loc.debugT("  DataCollectionTime:               {0}", new Object[]{new Integer(ccmsProperties.getDataCollectionInterval()).toString()});
            loc.debugT("  Thresholds:                       {0}", new Object[]{thresholds});
        }
        switch (ccmsNodeType) {
            case 300: {
                return NodeFactory.createPerfValueAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 304: {
                return NodeFactory.createPerfQualityAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 301: {
                return NodeFactory.createPerfFreqAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 305: {
                return NodeFactory.createPerfAvailAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 302: {
                return NodeFactory.createPerfCounterAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 303: {
                return NodeFactory.createPerfCounterSecAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 306: {
                return NodeFactory.createPerfOccupAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
            case 307: {
                return NodeFactory.createPerfOccupDiffAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (PerformanceProperties)ccmsProperties);
            }
        }
        throw new CcmsConnectorException("Unknown CCMS performance type.", true);
    }

    private TextAttribute createTextAttribute(IMonitorNode j2eeNode, ObjectNode ccmsParent, String text, AttributeNodeProperties properties) throws JMonException {
        String name = j2eeNode.getName();
        XMIMessage description = this.getDescription(j2eeNode);
        MethodSet defaultMethods = properties.getMethods();
        MethodSet methods = this.getMethods(j2eeNode, defaultMethods);
        properties.setMethods(methods);
        this.setDataCollectionTime(j2eeNode, properties);
        return NodeFactory.createTextAttribute((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (String)text, (AttributeNodeProperties)properties);
    }

    private TextAttribute createTextAttribute4Table(ITableMonitorNode j2eeNode, ObjectNode ccmsParent) throws JMonException {
        MethodSet defaultMethods = new MethodSet(new AnalysisMethod(ANALYSIS_SHOW_TABLE));
        MethodSet methods = this.getMethods(j2eeNode, defaultMethods);
        AttributeNodeProperties nodeProperties = new AttributeNodeProperties(j2eeNode.getConfigurationGroup());
        nodeProperties.setMethods(methods);
        return this.createTextAttribute(j2eeNode, ccmsParent, this.params.getTableDirectory() + j2eeNode.getTableFileName(), nodeProperties);
    }

    private Vector createMultipleTextAttributes(IMonitorNode j2eeNode, ObjectNode ccmsParent, String[][] newProperties) {
        Vector<TextAttribute> newCcmsNodes = new Vector<TextAttribute>();
        Vector oldCcmsNodes = (Vector)this.registry.get(j2eeNode);
        if (oldCcmsNodes == null) {
            this.deleteNodes(ccmsParent, j2eeNode.getName());
            oldCcmsNodes = new Vector();
        } else {
            oldCcmsNodes = (Vector)oldCcmsNodes.clone();
        }
        String mteClass = j2eeNode.getConfigurationGroup();
        XMIMessage description = this.getDescription(j2eeNode);
        MethodSet methods = this.getMethods(j2eeNode, null);
        AttributeNodeProperties nodeProperties = new AttributeNodeProperties(mteClass);
        nodeProperties.setMethods(methods);
        this.setDataCollectionTime(j2eeNode, nodeProperties);
        if (newProperties != null) {
            int i = 0;
            while (i < newProperties.length) {
                try {
                    StringBuffer name = new StringBuffer(j2eeNode.getName());
                    name.append(PROPERTIES_SEPARATOR).append(newProperties[i][0]);
                    TextAttribute property = NodeFactory.createTextAttribute((MonitoringNode)ccmsParent, (String)name.toString(), (XMIMessage)description, (String)newProperties[i][1], (AttributeNodeProperties)nodeProperties);
                    newCcmsNodes.add(property);
                    oldCcmsNodes.remove(property);
                }
                catch (Throwable all) {
                    this.trace.print("createMultipleTextAttributes: CreateTextAttribute failed (" + all.getMessage() + ").", all, false);
                }
                ++i;
            }
        }
        this.deleteNodes(oldCcmsNodes);
        return newCcmsNodes;
    }

    private Vector createPropertiesAttribute(IPropertiesMonitorNode j2eeNode, ObjectNode ccmsParent) {
        return this.createMultipleTextAttributes(j2eeNode, ccmsParent, j2eeNode.getProperties());
    }

    private Vector createSystemPropertiesAttribute(ITableMonitorNode j2eeNode, ObjectNode ccmsParent) {
        return this.createMultipleTextAttributes(j2eeNode, ccmsParent, this.cast2StringArray(j2eeNode.getEntries()));
    }

    private TableAttribute createTableAttribute(ITableMonitorNode j2eeNode, ObjectNode ccmsParent) throws CcmsConnectorException, JMonException {
        String fileName = this.params.getTableDirectory() + j2eeNode.getTableFileName();
        try {
            File file = new File(fileName);
            file.createNewFile();
            TextAttribute ccmsNode = this.createTextAttribute4Table(j2eeNode, ccmsParent);
            return new TableAttribute(ccmsNode, file);
        }
        catch (IOException e) {
            throw new CcmsConnectorException("Could not create file '" + fileName + "'. Check permissions in the file system.");
        }
    }

    private Object createMonitoringNode(IMonitorNode j2eeNode, int ccmsNodeType) throws CcmsConnectorException, JMonException {
        MonitoringNode ccmsParent = null;
        IMonitorNode j2eeParent = j2eeNode.getParent();
        if (j2eeParent != null) {
            ccmsParent = (MonitoringNode)this.registry.get(j2eeParent);
        }
        try {
            if (ccmsNodeType == 600) {
                return j2eeNode.getPath().equals(SYSTEM_PROPS_PATH) ? this.createSystemPropertiesAttribute((ITableMonitorNode)j2eeNode, (ObjectNode)ccmsParent) : this.createPropertiesAttribute((IPropertiesMonitorNode)j2eeNode, (ObjectNode)ccmsParent);
            }
            if (ccmsNodeType >= 500) {
                throw new CcmsConnectorException("LogAttributes are not supported.");
            }
            if (ccmsNodeType >= 400) {
                return this.createStatusAttribute((ObjectNode)ccmsParent, ccmsNodeType, (ICommonStateMonitorNode)j2eeNode);
            }
            if (ccmsNodeType >= 300) {
                return this.createPerformanceAttribute((ObjectNode)ccmsParent, ccmsNodeType, (IPerformanceMonitorNode)j2eeNode);
            }
            if (ccmsNodeType == 200) {
                return this.createTextAttribute(j2eeNode, (ObjectNode)ccmsParent, ((IStringMonitorNode)j2eeNode).getText(), new AttributeNodeProperties(j2eeNode.getConfigurationGroup()));
            }
            if (ccmsNodeType == 201) {
                return this.createTableAttribute((ITableMonitorNode)j2eeNode, (ObjectNode)ccmsParent);
            }
            String name = j2eeNode.getName();
            String mteClass = j2eeNode.getConfigurationGroup();
            XMIMessage description = this.getDescription(j2eeNode);
            MethodSet methods = this.getMethods(j2eeNode, null);
            MonitoringNodeProperties ccmsProperties = new MonitoringNodeProperties(mteClass, methods);
            switch (ccmsNodeType) {
                case 102: {
                    return NodeFactory.createObjectNode((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (MonitoringNodeProperties)ccmsProperties);
                }
                case 101: {
                    return NodeFactory.createSummaryNode((MonitoringNode)ccmsParent, (String)name, (XMIMessage)description, (MonitoringNodeProperties)ccmsProperties);
                }
                case 100: {
                    return NodeFactory.createRootNode((String)(j2eeNode.getPath().equals("/") ? this.getEngineRootName() : (j2eeNode.getPath().equals(APPLICATIONS_PATH) ? this.getApplicationsRootName() : name)), (String)CONTEXT_OWNER, (XMIMessage)description, (MonitoringNodeProperties)ccmsProperties);
                }
            }
            throw new CcmsConnectorException("Unknown CCMS node type.", true);
        }
        catch (NoMoreSpaceException nmse) {
            this.registry.addInvalid(j2eeNode);
            String message = "Out of memory. See OSS note 657143 how to increase the segment size (" + nmse.getMessage() + ").";
            this.selfMonitoring.reportOutOfMemory(message);
            throw new CcmsConnectorException(message, true, nmse);
        }
        catch (IncompatibilityException ie) {
            this.registry.addInvalid(j2eeNode);
            String message = "Incompatibility detected. See OSS note 657143 how to handle this situation (" + ie.getMessage() + ").";
            this.selfMonitoring.reportIncompatibility(message);
            throw new CcmsConnectorException(message, true, ie);
        }
        catch (InvalidUniqueNameException iune) {
            this.registry.addInvalid(j2eeNode);
            String message = this.params.getJ2eeNodeNumber() + ": Invalid configuration group for node'" + j2eeNode.getPath() + "' (" + j2eeNode.getConfigurationGroup() + ", max. " + 40 + " characters)";
            this.selfMonitoring.reportInvalidUniqueName(message);
            throw new CcmsConnectorException(message, true, iune);
        }
        catch (JMonException e) {
            if (e.getErrorCode() == 300) {
                this.registry.addInvalid(j2eeNode);
                String message = this.params.getJ2eeNodeNumber() + ": Invalid node name '" + j2eeNode.getPath() + "' (max. " + 40 + " characters)";
                this.selfMonitoring.reportInvalidUniqueName(message);
                throw new CcmsConnectorException(message, true, e);
            }
            throw e;
        }
    }

    private int doMapping(IMonitorNode j2eeNode) throws CcmsMapException {
        IMonitorNode j2eeParent = j2eeNode.getParent();
        int j2eeNodeType = j2eeNode.getTyp();
        if (j2eeNodeType == 0) {
            if (j2eeParent == null || j2eeNode.getPath().equals(APPLICATIONS_PATH)) {
                return 100;
            }
            if (j2eeParent.getTyp() != 0) {
                throw new CcmsMapException("Inner node under attribute.", true);
            }
            return j2eeNode instanceof ISummaryMonitorNode ? 101 : 102;
        }
        if (j2eeParent == null) {
            throw new CcmsMapException("Attribute is root.", true);
        }
        if (!(j2eeParent instanceof IObjectMonitorNode)) {
            throw new CcmsMapException("Attribute under root, summary or attribute.", true);
        }
        switch (j2eeNodeType) {
            case 9: 
            case 10: {
                return ((ICommonStateMonitorNode)j2eeNode).isExplicitGreen() ? 401 : 400;
            }
            case 6: {
                return 200;
            }
            case 16: 
            case 18: 
            case 19: {
                return 600;
            }
            case 1: 
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                return 300;
            }
            case 7: {
                return j2eeNode.getPath().equals(SYSTEM_PROPS_PATH) ? 600 : 201;
            }
        }
        throw new CcmsMapException("Unsupported J2EE node type (" + j2eeNodeType + ").", true);
    }

    public final void reportProperty(IMonitorNode j2eeNode, String[][] values) {
        if (loc.beDebug()) {
            loc.debugT("ReportProperty ({0})", new Object[]{j2eeNode.getPath()});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.registerNode(j2eeNode);
    }

    public final void reportString(IMonitorNode j2eeNode, String text) {
        if (loc.beDebug()) {
            loc.debugT("ReportString ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Text: {0}", new Object[]{text});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.registerNode(j2eeNode);
    }

    public final void reportTable(IMonitorNode j2eeNode, String[] header, Serializable[][] entries) {
        block10: {
            if (loc.beDebug()) {
                loc.debugT("ReportTable ({0})", new Object[]{j2eeNode.getPath()});
                if (this.params.getTracelevel() > 4) {
                    loc.catching(new Throwable());
                }
            }
            try {
                if (j2eeNode.getPath().equals(SYSTEM_PROPS_PATH)) {
                    this.reportProperty(j2eeNode, this.cast2StringArray(entries));
                    break block10;
                }
                TableAttribute tableNode = (TableAttribute)this.registry.get(j2eeNode);
                if (tableNode == null) {
                    if (this.registry.isInvalid(j2eeNode)) {
                        return;
                    }
                    this.registerNode(j2eeNode);
                    tableNode = (TableAttribute)this.registry.get(j2eeNode);
                } else {
                    TextAttribute ccmsNode = tableNode.getCcmsNode();
                    try {
                        ccmsNode.update();
                    }
                    catch (NodeNotExistingException nnee) {
                        this.registerNode(j2eeNode);
                        tableNode = (TableAttribute)this.registry.get(j2eeNode);
                    }
                }
                tableNode.writeTableToFile((Serializable[])header, entries);
            }
            catch (Throwable t) {
                this.trace.print("ReportTable", j2eeNode, t, true);
            }
        }
    }

    public final void reportDuration(IMonitorNode j2eeNode, double duration) {
        if (loc.beDebug()) {
            loc.debugT("ReportDuration ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Duration: {0}", new Object[]{new Double(duration)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.doReportInteger(j2eeNode, this.cast2Int(duration));
    }

    public final void reportInteger(IMonitorNode j2eeNode, int value) {
        if (loc.beDebug()) {
            loc.debugT("ReportInteger ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Value: {0}", new Object[]{new Integer(value)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.doReportInteger(j2eeNode, value);
    }

    public final void reportLong(IMonitorNode j2eeNode, long value) {
        if (loc.beDebug()) {
            loc.debugT("ReportLong ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Value: {0}", new Object[]{new Long(value)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.doReportInteger(j2eeNode, this.cast2Int(value));
    }

    public final void reportQuality(IMonitorNode j2eeNode, double value) {
        if (loc.beDebug()) {
            loc.debugT("ReportQuality ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  QualityRate: {0}", new Object[]{new Double(value)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.doReportInteger(j2eeNode, this.cast2Int(value));
    }

    public final void reportFrequency(IMonitorNode j2eeNode, double value) {
        if (loc.beDebug()) {
            loc.debugT("ReportFrequency ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Value: {0}", new Object[]{new Double(value)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.doReportInteger(j2eeNode, this.cast2Int(value * 100.0));
    }

    public final void reportAvailability(IMonitorNode j2eeNode, double value) {
        if (loc.beDebug()) {
            loc.debugT("ReportAvailability ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Value: {0}", new Object[]{new Double(value)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        this.doReportInteger(j2eeNode, this.cast2Int(value));
    }

    private void doReportInteger(IMonitorNode j2eeNode, int value) {
        try {
            PerfValueAttribute ccmsNode = (PerfValueAttribute)this.registry.get(j2eeNode);
            if (ccmsNode == null) {
                if (this.registry.isInvalid(j2eeNode)) {
                    return;
                }
                this.registerNode(j2eeNode);
                ccmsNode = (PerfValueAttribute)this.registry.get(j2eeNode);
                if (ccmsNode == null) {
                    throw new NodeNotExistingException("Node is null.");
                }
                ccmsNode.report(value);
            } else {
                try {
                    ccmsNode.report(value);
                }
                catch (NodeNotExistingException nnee) {
                    this.registerNode(j2eeNode);
                    ccmsNode = (PerfValueAttribute)this.registry.get(j2eeNode);
                    ccmsNode.report(value);
                }
            }
        }
        catch (NodeNotExistingException e) {
            this.trace.print("DoReportInteger", j2eeNode, e, false);
        }
        catch (Throwable t) {
            this.trace.print("DoReportInteger", j2eeNode, t, true);
        }
    }

    public final void reportStatus(IMonitorNode j2eeNode, String text, int alertValue) {
        if (loc.beDebug()) {
            loc.debugT("ReportStatus ({0})", new Object[]{j2eeNode.getPath()});
            loc.debugT("  Text: {0}", new Object[]{text});
            loc.debugT("  AlertValue: {0}", new Object[]{new Integer(alertValue)});
            if (this.params.getTracelevel() > 4) {
                loc.catching(new Throwable());
            }
        }
        try {
            StatusLineAttribute ccmsNode = (StatusLineAttribute)this.registry.get(j2eeNode);
            if (ccmsNode == null) {
                if (this.registry.isInvalid(j2eeNode)) {
                    return;
                }
                this.registerNode(j2eeNode);
                ccmsNode = (StatusLineAttribute)this.registry.get(j2eeNode);
                if (ccmsNode == null) {
                    throw new NodeNotExistingException("Node is null.");
                }
                ccmsNode.report(this.getAlertValue(alertValue), text);
            } else {
                try {
                    ccmsNode.report(this.getAlertValue(alertValue), text);
                }
                catch (NodeNotExistingException nnee) {
                    this.registerNode(j2eeNode);
                    ccmsNode = (StatusLineAttribute)this.registry.get(j2eeNode);
                    ccmsNode.report(this.getAlertValue(alertValue), text);
                }
            }
        }
        catch (NodeNotExistingException ex) {
            this.trace.print("ReportStatus", j2eeNode, ex, false);
        }
        catch (CcmsConnectorException e) {
            this.trace.print("ReportStatus", j2eeNode, e, e.isFatal());
        }
        catch (Throwable t) {
            this.trace.print("ReportStatus", j2eeNode, t, true);
        }
    }

    public final void registerNode(IMonitorNode j2eeNode) {
        try {
            if (j2eeNode == null) {
                throw new CcmsConnectorException("Node is null.", true);
            }
            if (loc.beInfo()) {
                loc.infoT("RegisterNode ({0}, {1})", new Object[]{j2eeNode.getName(), j2eeNode.getConfigurationGroup()});
                if (loc.beDebug()) {
                    loc.debugT("  Type:          {0}", new Object[]{j2eeNode.getClass().getName()});
                    loc.debugT("  Path:          {0}", new Object[]{j2eeNode.getPath()});
                    loc.debugT("  Parent:        {0}", new Object[]{j2eeNode.getParent()});
                    loc.debugT("  DescriptionID: {0}", new Object[]{j2eeNode.getDescriptionID()});
                    if (this.params.getTracelevel() > 4) {
                        loc.catching(new Throwable());
                    }
                }
            }
            if (this.registry.isInvalid(j2eeNode)) {
                return;
            }
            int ccmsNodeType = this.doMapping(j2eeNode);
            Object ccmsNode = null;
            try {
                ccmsNode = this.createMonitoringNode(j2eeNode, ccmsNodeType);
            }
            catch (NodeNotExistingException nnee) {
                this.registerNode(j2eeNode.getParent());
                if (this.registry.get(j2eeNode.getParent()) == null || this.registry.isInvalid(j2eeNode.getParent())) {
                    this.registry.addInvalid(j2eeNode);
                    throw new CcmsConnectorException(j2eeNode.getPath() + " can't be created due to missing parent node(s).", true);
                }
                ccmsNode = this.createMonitoringNode(j2eeNode, ccmsNodeType);
            }
            if (ccmsNode != null) {
                this.registry.addValid(j2eeNode, ccmsNode);
            }
        }
        catch (NodeNotExistingException ex) {
            this.trace.print("RegisterNode", j2eeNode, ex, false);
        }
        catch (CcmsConnectorException e) {
            this.trace.print("RegisterNode", j2eeNode, e, e.isFatal());
        }
        catch (Throwable t) {
            this.trace.print("RegisterNode", j2eeNode, t, true);
        }
    }

    public final void deregisterNode(IMonitorNode j2eeNode, boolean persistent) {
        try {
            if (j2eeNode == null) {
                throw new CcmsConnectorException("Node is null.", true);
            }
            if (loc.beInfo()) {
                loc.infoT("DeregisterNode ({0}, {1})", new Object[]{j2eeNode.getName(), new Boolean(persistent)});
                if (loc.beDebug()) {
                    loc.debugT("  Type:   {0}", new Object[]{j2eeNode.getClass().getName()});
                    loc.debugT("  Path:   {0}", new Object[]{j2eeNode.getPath()});
                    loc.debugT("  Parent: {0}", new Object[]{j2eeNode.getParent()});
                    if (this.params.getTracelevel() > 4) {
                        loc.catching(new Throwable());
                    }
                }
            }
            this.registry.remove(j2eeNode, persistent);
        }
        catch (CcmsConnectorException e) {
            this.trace.print("DeregisterNode", j2eeNode, e, e.isFatal());
        }
        catch (Throwable t) {
            this.trace.print("DeregisterNode", j2eeNode, t, true);
        }
    }

    public void removeApplication(String applicationName) {
        this.registry.remove(applicationName);
    }

    public void customizeGroup(String configurationGroup, Collection j2eeNodes) {
        try {
            if (j2eeNodes == null || j2eeNodes.isEmpty()) {
                throw new CcmsConnectorException("Empty configuration group.", false);
            }
            if (loc.beInfo()) {
                loc.infoT("CustomizeGroup ({0})", new Object[]{configurationGroup});
                if (loc.beDebug()) {
                    loc.debugT("  Size:   {0}", new Object[]{new Integer(j2eeNodes.size())});
                    if (this.params.getTracelevel() > 4) {
                        loc.catching(new Throwable());
                    }
                }
            }
            Iterator iter = j2eeNodes.iterator();
            while (iter.hasNext()) {
                IMonitorNode element = (IMonitorNode)iter.next();
                this.registerNode(element);
            }
        }
        catch (CcmsConnectorException e) {
            if (e.isFatal()) {
                loc.errorT("CustomizeGroup: " + e.toString());
            } else {
                loc.warningT("CustomizeGroup: " + e.toString());
            }
        }
        catch (Throwable t) {
            loc.errorT("CustomizeGroup: " + t.toString());
        }
    }

    private String getEngineRootName() {
        String engineRootName = this.params.getSid() + " " + this.params.getJ2eeInstanceNumber() + (this.params.isJ2eeDispatcher() ? " Disp " : " Serv ") + this.params.getJ2eeNodeNumber() + " " + this.getHostName();
        if (engineRootName.length() > 40) {
            engineRootName = engineRootName.substring(0, 40);
            loc.warningT("Engine root name was truncated.");
        }
        return engineRootName;
    }

    private String getApplicationsRootName() {
        String applicationsRootName = this.params.getSid() + " " + this.params.getJ2eeInstanceNumber() + " Appl " + this.params.getJ2eeNodeNumber() + " " + this.getHostName();
        if (applicationsRootName.length() > 40) {
            applicationsRootName = applicationsRootName.substring(0, 40);
            loc.warningT("Applications root name was truncated.");
        }
        return applicationsRootName;
    }

    private String getHostName() {
        try {
            String host = MonitoringAgent.getHostName();
            if (host == null || host.length() == 0) {
                throw new Exception("Invalid host name (" + host + ").");
            }
            return host;
        }
        catch (Throwable t) {
            this.trace.print("Could not read host name (" + t.toString() + ")", t, true);
            return null;
        }
    }

    private AlertValue getAlertValue(int j2eeColor) throws CcmsReportingException {
        switch (j2eeColor) {
            case 1: {
                return AlertValue.GREEN;
            }
            case 2: {
                return AlertValue.YELLOW;
            }
            case 3: {
                return AlertValue.RED;
            }
            case 0: {
                throw new CcmsReportingException("Alert value is 'WHITE'.", false);
            }
        }
        throw new CcmsReportingException("Unknown alert value.", true);
    }

    private XMIMessage getDescription(IMonitorNode j2eeNode) {
        try {
            String descriptionID = j2eeNode.getDescriptionID();
            if (descriptionID != null && descriptionID.length() > 0) {
                return new XMIMessage(XMI_MESSAGE_CLASS, descriptionID);
            }
        }
        catch (Exception e) {
            this.trace.print("Bad description ID (" + j2eeNode.getDescriptionID() + ") for " + j2eeNode.getName() + ".", e, false);
        }
        return T100Message.getDefaultMessage();
    }

    private void setDataCollectionTime(IMonitorNode j2eeNode, AttributeNodeProperties ccmsProperties) {
        if (j2eeNode.getDataCollectionType() == 0) {
            int factor = j2eeNode.getPeriodUnit() == 0 ? 60 : (j2eeNode.getPeriodUnit() == 1 ? 3600 : 86400);
            int dataCollectionTime = j2eeNode.getPeriodValue() * factor;
            ccmsProperties.setDataCollectionInterval(dataCollectionTime);
            ccmsProperties.setInactiveTime(dataCollectionTime + 300);
        } else {
            ccmsProperties.setDataCollectionInterval(0);
            ccmsProperties.setInactiveTime(0);
        }
    }

    private MethodSet getMethods(IMonitorNode j2eeNode, MethodSet defaultMethods) {
        if (defaultMethods == null) {
            defaultMethods = new MethodSet(null, null, null);
        }
        if (j2eeNode.getAnalysisMethod() != null && j2eeNode.getAnalysisMethod().length() != 0) {
            defaultMethods.setAnalysisMethod(new AnalysisMethod(j2eeNode.getAnalysisMethod()));
        } else if (defaultMethods.getAnalysisMethod() != null) {
            j2eeNode.setAnalysisMethod(defaultMethods.getAnalysisMethod().getName());
        }
        if (j2eeNode.getAutoreactionMethod() != null && j2eeNode.getAutoreactionMethod().length() != 0) {
            defaultMethods.setAutoReactionMethod(new AutoReactionMethod(j2eeNode.getAutoreactionMethod()));
        } else if (defaultMethods.getAutoReactionMethod() != null) {
            j2eeNode.setAutoreactionMethod(defaultMethods.getAutoReactionMethod().getName());
        }
        return defaultMethods;
    }

    private Thresholds getThresholds(IPerformanceMonitorNode j2eeNode) {
        IThresholds j2eeThresholds = j2eeNode.getThresholds();
        Object thresholds = j2eeNode instanceof IFrequencyMonitorNode ? (j2eeThresholds.getDirection() == 1 ? new ExceedThresholds(100 * j2eeThresholds.getThresholdFromGreenToYellow(), 100 * j2eeThresholds.getThresholdFromYellowToRed(), 100 * j2eeThresholds.getThresholdFromYellowToGreen(), 100 * j2eeThresholds.getThresholdFromRedToYellow()) : new FallbelowThresholds(100 * j2eeThresholds.getThresholdFromGreenToYellow(), 100 * j2eeThresholds.getThresholdFromYellowToRed(), 100 * j2eeThresholds.getThresholdFromYellowToGreen(), 100 * j2eeThresholds.getThresholdFromRedToYellow())) : (j2eeThresholds.getDirection() == 1 ? new ExceedThresholds(j2eeThresholds.getThresholdFromGreenToYellow(), j2eeThresholds.getThresholdFromYellowToRed(), j2eeThresholds.getThresholdFromYellowToGreen(), j2eeThresholds.getThresholdFromRedToYellow()) : new FallbelowThresholds(j2eeThresholds.getThresholdFromGreenToYellow(), j2eeThresholds.getThresholdFromYellowToRed(), j2eeThresholds.getThresholdFromYellowToGreen(), j2eeThresholds.getThresholdFromRedToYellow()));
        return thresholds;
    }

    private int getAlertRelevantValueType(IPerformanceMonitorNode j2eeNode, int ccmsNodeType) {
        int relevantValue = j2eeNode.getAlertRelevantValueType();
        if (ccmsNodeType == 301 && (relevantValue == 1 || relevantValue == 2 || relevantValue == 3)) {
            return 4;
        }
        return relevantValue;
    }

    private void deleteNodes(ObjectNode ccmsParent, String j2eeName) {
        try {
            Iterator ccmsNodes = ((AbstractList)NodeFactory.getSubNodes((MonitoringNode)ccmsParent, (int)1)).iterator();
            while (ccmsNodes.hasNext()) {
                MonitoringNode ccmsNode = (MonitoringNode)ccmsNodes.next();
                String ccmsNodeName = NodeFactory.getNonAbbreviatedName((String)ccmsNode.getName());
                if (!ccmsNodeName.startsWith(j2eeName + PROPERTIES_SEPARATOR)) continue;
                try {
                    NodeFactory.deleteNode((MonitoringNode)ccmsNode);
                }
                catch (Throwable t) {
                    this.trace.print("deleteNodes: DeleteNode failed (" + t.getMessage() + ").", t, false);
                }
            }
        }
        catch (Throwable all) {
            this.trace.print("deleteNodes: GetSubNodes failed (" + all.getMessage() + ").", all, false);
        }
    }

    private void deleteNodes(Vector ccmsNodes) {
        Iterator iter = ((AbstractList)ccmsNodes).iterator();
        while (iter.hasNext()) {
            try {
                NodeFactory.deleteNode((MonitoringNode)((MonitoringNode)iter.next()));
            }
            catch (Throwable t) {
                loc.warningT("deleteNodes: DeleteNode failed (" + t.getMessage() + ").");
            }
        }
    }

    private String[][] cast2StringArray(Serializable[][] inArray) {
        String[][] outArray = null;
        if (inArray != null && inArray.length != 0 && inArray[0] != null) {
            outArray = new String[inArray.length][2];
            int i = 0;
            while (i < inArray.length) {
                outArray[i][0] = (String)((Object)inArray[i][0]);
                outArray[i][1] = (String)((Object)inArray[i][1]);
                ++i;
            }
        }
        return outArray;
    }

    private int cast2Int(double value) {
        if (value > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (value < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    private void finalCleanUp() {
        this.registry.cleanUp();
        this.registry = null;
        this.params = null;
        this.selfMonitoring = null;
        this.trace.close();
        this.trace = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

