/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping;

import com.sap.engine.library.monitor.IValueChangeListener;
import com.sap.engine.library.monitor.ValueChangeEvent;
import com.sap.engine.library.monitor.gui.tree.MonitorTreeNode;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class MappingTreeNode
extends MonitorTreeNode
implements IValueChangeListener {
    protected String m_path;
    protected Properties m_properties;
    protected transient Vector m_changeListeners = new Vector(0);
    private transient Object m_additionalMappingObject;

    public MappingTreeNode() {
    }

    public MappingTreeNode(String name, int type, Icon icon) {
        super(name, type, icon);
    }

    public String getMappingPath() {
        return this.m_path;
    }

    public void setMappingPath(String path) {
        this.m_path = path;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void setProperties(Properties p) {
        this.m_properties = p;
    }

    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    public void addProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    public Object getAdditionalMappingObject() {
        return this.m_additionalMappingObject;
    }

    public void setAdditionalMappingObject(Object obj) {
        this.m_additionalMappingObject = obj;
    }

    public void stateChanged(ValueChangeEvent event) {
        event.changeSource(this);
        int i = this.m_changeListeners.size() - 1;
        while (i >= 0) {
            ((IValueChangeListener)this.m_changeListeners.elementAt(i)).stateChanged(event);
            --i;
        }
    }

    public void registerEventListener(IValueChangeListener listener) {
        this.m_changeListeners.addElement(listener);
    }

    public void unregisterEventListener(IValueChangeListener listener) {
        this.m_changeListeners.removeElement(listener);
    }

    public int getColorRecursive() {
        int maxColor = 0;
        if (this.node != null) {
            maxColor = this.node.getStatusColor();
        }
        Enumeration<TreeNode> e = this.children();
        MappingTreeNode currentNode = null;
        int currentColor = 0;
        while (e.hasMoreElements()) {
            currentNode = (MappingTreeNode)e.nextElement();
            currentColor = currentNode.getColorRecursive();
            if (currentColor <= maxColor) continue;
            maxColor = currentColor;
        }
        return maxColor;
    }

    public MappingTreeNode subNodeWithName(String name) {
        MappingTreeNode m_node = null;
        int i = 0;
        while (i < this.getChildCount()) {
            m_node = (MappingTreeNode)this.getChildAt(i);
            if (name.equals(m_node.getName())) {
                return m_node;
            }
            ++i;
        }
        return null;
    }
}

