/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.mapping;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.IMonitorTreeStructureChangeEvent;
import com.sap.engine.library.monitor.IMonitorTreeStructureListener;
import com.sap.engine.library.monitor.MonitorFactory;
import com.sap.engine.library.monitor.mapping.MappingPropertiesProvider;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.library.monitor.util.NodeFinder;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MappedTree
implements IMonitorTreeStructureListener,
Comparator,
Serializable {
    private MappingTreeNode m_root = null;
    protected String m_treeName = "";
    protected MappingPropertiesProvider m_propertiesProvider = new MappingPropertiesProvider();
    protected boolean m_registerMappedNodesAsChangeListener = false;

    public MappedTree(String xml) {
        if (xml != null && xml.length() != 0) {
            this.init(xml);
        }
    }

    public MappedTree(String xml, boolean registerMappedNodesAsChangeListener) {
        this.m_registerMappedNodesAsChangeListener = registerMappedNodesAsChangeListener;
        if (xml != null && xml.length() != 0) {
            this.init(xml);
        }
    }

    public MappedTree(IMonitorNode root, String name) {
        this.m_root = new MappingTreeNode(root.getName(), root.getTyp(), null);
        this.m_root.setMappingPath(root.getPath());
        this.m_root.setMonitorObject(root);
        if (this.m_registerMappedNodesAsChangeListener) {
            root.registerEventListener(this.m_root);
        }
        this.m_treeName = name;
    }

    public MappedTree(IMonitorNode root, String name, boolean registerMappedNodesAsChangeListener) {
        this.m_registerMappedNodesAsChangeListener = registerMappedNodesAsChangeListener;
        this.init(root, name);
    }

    public MappedTree(IMonitorNode root, String name, MappingPropertiesProvider provider) {
        this.m_propertiesProvider = provider;
        this.m_root = new MappingTreeNode(root.getName(), root.getTyp(), null);
        this.m_root.setMappingPath(root.getPath());
        this.m_root.setMonitorObject(root);
        if (this.m_registerMappedNodesAsChangeListener) {
            root.registerEventListener(this.m_root);
        }
        this.m_treeName = name;
    }

    public MappedTree(IMonitorNode root, String name, MappingPropertiesProvider provider, boolean registerMappedNodesAsChangeListener) {
        this.m_registerMappedNodesAsChangeListener = registerMappedNodesAsChangeListener;
        this.m_propertiesProvider = provider;
        this.init(root, name);
    }

    public String getName() {
        return this.m_treeName;
    }

    public void setName(String name) {
        this.m_treeName = name;
    }

    protected void init(IMonitorNode root, String name) {
        this.m_root = new MappingTreeNode(root.getName(), root.getTyp(), null);
        if (this.m_registerMappedNodesAsChangeListener) {
            root.registerEventListener(this.m_root);
        }
        IMonitorNode[] subnodes = root.getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            this.addSubnode(subnodes[i].getName(), subnodes[i], this.m_root, null, true);
            ++i;
        }
        this.m_treeName = name;
        this.initCommon();
    }

    protected void init(String xml) {
        try {
            StringReader sr = new StringReader(xml);
            InputSource is = new InputSource(sr);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(is);
            doc.normalize();
            NodeList rootNodeList = doc.getChildNodes();
            Node tree = rootNodeList.item(0);
            Properties p = this.extractProperties(tree);
            Node[] rootList = this.extractSubNodes(tree);
            if (rootList.length > 0) {
                this.m_root = this.visitRecursive(rootList[0]);
                this.initCommon();
            }
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initCommon() {
        IMonitorObjectFactory factory = MonitorFactory.createMonitorObjectFactory();
        factory.getMonitorTreeListenerRegistry().registerStructureChangeListener(this);
        this.reactOnNodesAdded();
    }

    public void setMappingPropertiesProvider(MappingPropertiesProvider propertiesProvider) {
        this.m_propertiesProvider = propertiesProvider;
    }

    public MappingPropertiesProvider getMappingPropertiesProvider() {
        return this.m_propertiesProvider;
    }

    public String toXml() {
        String start = "<?xml version=\"1.0\"?><mappedTree name=\"" + this.m_treeName + "\">";
        String end = "</mappedTree>";
        if (this.m_root == null) {
            return start + end;
        }
        return start + this.createRecursiveXml(this.m_root) + end;
    }

    public MappingTreeNode getRootNode() {
        return this.m_root;
    }

    protected Node[] extractSubNodes(Node node) {
        if (!node.hasChildNodes()) {
            return new Node[0];
        }
        NodeList subNodes = node.getChildNodes();
        Vector<Node> v = new Vector<Node>();
        int i = 0;
        while (i < subNodes.getLength()) {
            if (subNodes.item(i).getNodeName().equals("node")) {
                v.addElement(subNodes.item(i));
            }
            ++i;
        }
        Object[] result = new Node[v.size()];
        v.copyInto(result);
        return result;
    }

    protected Properties extractProperties(Node node) {
        Properties p = new Properties();
        if (!node.hasChildNodes()) {
            return p;
        }
        NodeList subNodes = node.getChildNodes();
        Node currentNode = null;
        Node name = null;
        Node value = null;
        int i = 0;
        while (i < subNodes.getLength()) {
            currentNode = subNodes.item(i);
            if (currentNode.getNodeName().equals("property") && currentNode.hasAttributes()) {
                NamedNodeMap attributes = currentNode.getAttributes();
                name = attributes.getNamedItem("name");
                value = attributes.getNamedItem("value");
                ((Hashtable)p).put(name.getNodeValue(), value.getNodeValue());
            }
            ++i;
        }
        return p;
    }

    protected MappingTreeNode visitRecursive(Node node) {
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        String path = node.getAttributes().getNamedItem("path").getNodeValue();
        MappingTreeNode newNode = new MappingTreeNode(name, 0, null);
        newNode.m_path = path;
        Properties p = this.extractProperties(node);
        newNode.setProperties(p);
        Node[] subNodes = this.extractSubNodes(node);
        MappingTreeNode[] mappedSubNodes = new MappingTreeNode[subNodes.length];
        int i = 0;
        while (i < subNodes.length) {
            newNode.add(this.visitRecursive(subNodes[i]));
            ++i;
        }
        return newNode;
    }

    protected String createRecursiveXml(MappingTreeNode node) {
        String start = "<node> name =\"" + node.getName() + "\" path=\"" + node.m_path + "\">";
        if (node.m_properties != null) {
            Enumeration e = ((Hashtable)node.m_properties).keys();
            String keyName = null;
            String keyValue = null;
            while (e.hasMoreElements()) {
                keyName = (String)e.nextElement();
                keyValue = node.m_properties.getProperty(keyName);
                start = start + "<property name=\"" + keyName + "\" value=\"" + keyValue + "\">";
            }
        }
        int noOfSubnodes = node.getChildCount();
        int i = 0;
        while (i < noOfSubnodes) {
            start = start + this.createRecursiveXml((MappingTreeNode)node.getChildAt(i));
            ++i;
        }
        String end = "</node>";
        return start + end;
    }

    public void reactOnNodesAdded() {
        if (this.m_root != null) {
            this.reactOnNodesAddedRecursive(this.m_root);
        }
    }

    protected void reactOnNodesAddedRecursive(MappingTreeNode node) {
        IMonitorNode newMonitorNode;
        if (node.getMonitorObject() == null && (newMonitorNode = NodeFinder.findNode(node.getMappingPath())) != null) {
            node.setMonitorObject(newMonitorNode);
            node.setType(newMonitorNode.getTyp());
            if (this.m_registerMappedNodesAsChangeListener) {
                newMonitorNode.registerEventListener(node);
            }
        }
        int subLength = node.getChildCount();
        MappingTreeNode currentNode = null;
        int i = 0;
        while (i < subLength) {
            currentNode = (MappingTreeNode)node.getChildAt(i);
            this.reactOnNodesAddedRecursive(currentNode);
            ++i;
        }
    }

    public MappingTreeNode addSubnode(String name, IMonitorNode node, MappingTreeNode parent, Icon icon, boolean addWithSubnodes) {
        int type = 0;
        if (node != null) {
            type = node.getTyp();
        }
        MappingTreeNode newNode = new MappingTreeNode(name, type, icon);
        newNode.setMappingPath(node.getPath());
        newNode.setMonitorObject(node);
        if (this.m_registerMappedNodesAsChangeListener) {
            node.registerEventListener(newNode);
        }
        Properties prop = this.m_propertiesProvider.getDefaultProperties(type);
        newNode.setProperties(prop);
        parent.insert(newNode, this.getNodeIndex(parent, newNode));
        if (addWithSubnodes) {
            IMonitorNode[] subnodes = node.getSubNodes();
            int i = 0;
            while (i < subnodes.length) {
                this.addSubnode(subnodes[i].getName(), subnodes[i], newNode, icon, true);
                ++i;
            }
        }
        return newNode;
    }

    private int getNodeIndex(MappingTreeNode parent, MappingTreeNode subNode) {
        int size = parent.getChildCount();
        if (size == 0) {
            return 0;
        }
        MappingTreeNode node = null;
        int i = 0;
        while (i < size) {
            node = (MappingTreeNode)parent.getChildAt(i);
            if (this.compare(node, subNode) > 0) {
                return i;
            }
            ++i;
        }
        return size;
    }

    public void removeSubnode(MappingTreeNode node) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent != null) {
            parent.remove(node);
        } else if (node == this.m_root) {
            this.m_root = null;
        }
        if (this.m_registerMappedNodesAsChangeListener) {
            node.getMonitorObject().unregisterEventListener(node);
            int no = node.getChildCount();
            int i = 0;
            while (i < no) {
                MappingTreeNode sn = (MappingTreeNode)node.getChildAt(i);
                this.removeSubnode(sn);
                ++i;
            }
        }
    }

    public void reactOnMonitorTreeStructureChange(IMonitorTreeStructureChangeEvent event) {
        if (event.nodeAdded()) {
            this.reactOnNodesAdded();
        }
    }

    public void updateTree(IMonitorNode root, String name, MappingPropertiesProvider provider) {
        this.m_propertiesProvider = provider;
        this.init(root, name);
    }

    public MappingTreeNode search(IMonitorNode node) {
        Vector<String> vectorPath = new Vector<String>(10);
        IMonitorNode current = node;
        while (!current.getName().equals(this.m_root.getName())) {
            vectorPath.add(current.getName());
            current = current.getParent();
        }
        MappingTreeNode m_current = this.m_root;
        int i = vectorPath.size() - 1;
        while (i >= 0) {
            m_current = m_current.subNodeWithName((String)vectorPath.get(i));
            --i;
        }
        vectorPath.removeAllElements();
        return m_current;
    }

    public MappingTreeNode getMappingTreeNode(String path, String separator) {
        if (!path.startsWith(separator + this.m_root.getName())) {
            return null;
        }
        path = path.substring(separator.length() + this.m_root.getName().length());
        MappingTreeNode node = this.m_root;
        if (!path.equals("")) {
            path = path.substring(separator.length());
        }
        while (!path.equals("")) {
            String name;
            if (path.indexOf(separator) != -1) {
                name = path.substring(0, path.indexOf(separator));
                path = path.substring(path.indexOf(separator) + separator.length());
            } else {
                name = path;
                path = "";
            }
            System.out.println("token: " + name + " :path: " + path + " :");
            node = node.subNodeWithName(name);
            if (node != null) continue;
            return null;
        }
        return node;
    }

    public int compare(Object o1, Object o2) {
        MappingTreeNode node1 = (MappingTreeNode)o1;
        MappingTreeNode node2 = (MappingTreeNode)o2;
        return node1.getName().compareTo(node2.getName());
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public Vector getNodesForGroupName(String groupName) {
        Vector nodes = new Vector();
        this.searchForGroupName(this.m_root, groupName, nodes);
        return nodes;
    }

    private void searchForGroupName(MappingTreeNode node, String groupName, Vector nodes) {
        if (node.getMonitorObject().getConfigurationGroup().equals(groupName)) {
            nodes.add(node);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.searchForGroupName((MappingTreeNode)node.getChildAt(i), groupName, nodes);
            ++i;
        }
    }
}

