/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.MonitorException;
import java.io.Serializable;

public class Thresholds
implements Serializable,
IThresholds {
    private int m_thresholdFromGreenToYellow;
    private int m_thresholdFromYellowToRed;
    private int m_thresholdFromYellowToGreen;
    private int m_thresholdFromRedToYellow;
    private int m_direction = 0;

    public Thresholds(int thresholdG2Y, int thresholdY2R) throws MonitorException {
        this(thresholdG2Y, thresholdY2R, thresholdG2Y, thresholdY2R);
    }

    public Thresholds(int thresholdG2Y, int thresholdY2R, int thresholdY2G, int thresholdR2Y) throws MonitorException {
        this.m_thresholdFromGreenToYellow = thresholdG2Y;
        this.m_thresholdFromYellowToRed = thresholdY2R;
        this.m_thresholdFromYellowToGreen = thresholdY2G;
        this.m_thresholdFromRedToYellow = thresholdR2Y;
        this.calculateDirection();
        this.checkConsistency(thresholdG2Y, thresholdY2R, thresholdY2G, thresholdR2Y);
    }

    public void setThresholdFromGreenToYellow(int thresholdG2Y) throws MonitorException {
        this.checkConsistency(thresholdG2Y, this.m_thresholdFromYellowToRed, this.m_thresholdFromYellowToGreen, this.m_thresholdFromRedToYellow);
        this.m_thresholdFromGreenToYellow = thresholdG2Y;
    }

    public int getThresholdFromGreenToYellow() {
        return this.m_thresholdFromGreenToYellow;
    }

    public void setThresholdFromYellowToGreen(int thresholdY2G) throws MonitorException {
        this.checkConsistency(this.m_thresholdFromGreenToYellow, this.m_thresholdFromYellowToRed, thresholdY2G, this.m_thresholdFromRedToYellow);
        this.m_thresholdFromYellowToGreen = thresholdY2G;
    }

    public int getThresholdFromYellowToGreen() {
        return this.m_thresholdFromYellowToGreen;
    }

    public void setThresholdFromYellowToRed(int thresholdY2R) throws MonitorException {
        this.checkConsistency(this.m_thresholdFromGreenToYellow, thresholdY2R, this.m_thresholdFromYellowToGreen, this.m_thresholdFromRedToYellow);
        this.m_thresholdFromYellowToRed = thresholdY2R;
    }

    public int getThresholdFromYellowToRed() {
        return this.m_thresholdFromYellowToRed;
    }

    public void setThresholdFromRedToYellow(int thresholdR2Y) throws MonitorException {
        this.checkConsistency(this.m_thresholdFromGreenToYellow, this.m_thresholdFromYellowToRed, this.m_thresholdFromYellowToGreen, thresholdR2Y);
        this.m_thresholdFromRedToYellow = thresholdR2Y;
    }

    public int getThresholdFromRedToYellow() {
        return this.m_thresholdFromRedToYellow;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public boolean equals(Object obj) {
        return obj instanceof Thresholds && this.getClass().equals(obj.getClass()) && this.m_thresholdFromGreenToYellow == ((Thresholds)obj).getThresholdFromGreenToYellow() && this.m_thresholdFromYellowToRed == ((Thresholds)obj).getThresholdFromYellowToRed() && this.m_thresholdFromYellowToGreen == ((Thresholds)obj).getThresholdFromYellowToGreen() && this.m_thresholdFromRedToYellow == ((Thresholds)obj).getThresholdFromRedToYellow();
    }

    public String toString() {
        return "(" + (this.m_direction == 1 ? "UP" : "DOWN") + ", " + this.m_thresholdFromGreenToYellow + ", " + this.m_thresholdFromYellowToRed + ", " + this.m_thresholdFromYellowToGreen + ", " + this.m_thresholdFromRedToYellow + ")";
    }

    protected void calculateDirection() throws MonitorException {
        if (this.m_thresholdFromGreenToYellow < this.m_thresholdFromRedToYellow) {
            this.m_direction = 1;
        } else if (this.m_thresholdFromGreenToYellow > this.m_thresholdFromRedToYellow) {
            this.m_direction = -1;
        } else {
            throw new MonitorException("Thresholds  green to yellow: " + this.m_thresholdFromGreenToYellow + " yellow to red: " + this.m_thresholdFromRedToYellow + "yellow to green: " + this.m_thresholdFromYellowToGreen + "red to yellow: " + this.m_thresholdFromRedToYellow + " are inconsistent.");
        }
    }

    protected void checkConsistency(int gTy, int yTr, int yTg, int rTy) throws MonitorException {
        boolean consistent = true;
        if (this.m_direction == 1) {
            if (gTy < yTg || rTy <= gTy || yTr < rTy) {
                consistent = false;
            }
        } else if (gTy > yTg || rTy >= gTy || yTr > rTy) {
            consistent = false;
        }
        if (!consistent) {
            throw new MonitorException("Thresholds  green to yellow: " + gTy + " yellow to red: " + yTr + "yellow to green: " + yTg + "red to yellow: " + rTy + " are inconsistent.");
        }
    }

    public String toXml() {
        return "<threshold direction=\"" + (this.m_direction == 1 ? "UP" : "DOWN") + "\" greenToYellow=\"" + this.m_thresholdFromGreenToYellow + "\" yellowToRed=\" " + this.m_thresholdFromYellowToRed + "\" yellowToGreen=\" " + this.m_thresholdFromYellowToGreen + "\" RedToYellow=\" " + this.m_thresholdFromRedToYellow + "\"/>";
    }
}

