/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.AttributeMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class TableMonitorNode
extends AttributeMonitorNode
implements ITableMonitorNode {
    protected Serializable[][] m_entries = new Serializable[0][0];
    protected String[] m_header = new String[0];
    private String tableFileName = "";

    public TableMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public void setEntries(Serializable[][] entries) throws IllegalArgumentException {
        this.hasReportedValue = true;
        try {
            Serializable[][] copy = new Serializable[entries.length][entries[0].length];
            int i = 0;
            while (i < entries.length) {
                int j = 0;
                while (j < entries[0].length) {
                    copy[i][j] = entries[i][j];
                    ++j;
                }
                ++i;
            }
            this.m_entries = copy;
            this.internalStateChanged();
        }
        catch (RuntimeException e) {
            AbstractMonitorNode.location.warningT("Entries for the table monitor node with path [" + this.getPath() + "] are null or the array has not a rectangular form");
            throw new IllegalArgumentException();
        }
    }

    public String getTableFileName() {
        return this.tableFileName;
    }

    public void setTableFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Filename was null.");
        }
        this.tableFileName = fileName;
    }

    public void setHeader(String[] header) {
        this.m_header = header;
        this.internalStateChanged();
    }

    public Serializable[] getHeader() {
        return this.m_header;
    }

    public void changeEntry(int rowIndex, int colIndex, Serializable entry) {
        this.m_entries[rowIndex][colIndex] = entry;
        this.internalStateChanged();
    }

    public void addRow(Serializable[] row) {
        int len = this.m_entries.length;
        Serializable[][] entries = new Serializable[len + 1][];
        int i = 0;
        while (i < len) {
            entries[i] = this.m_entries[i];
            ++i;
        }
        entries[len] = row;
        this.m_entries = entries;
        this.internalStateChanged();
    }

    public Serializable entryAt(int rowPos, int colPos) {
        return this.m_entries[rowPos][colPos];
    }

    public Serializable[] rowAt(int index) {
        return this.m_entries[index];
    }

    public Serializable[][] getEntries() {
        return this.m_entries;
    }

    public void swapRows(int i, int j) {
        Serializable[] temp = this.m_entries[i];
        this.m_entries[i] = this.m_entries[j];
        this.m_entries[j] = temp;
        this.internalStateChanged();
    }

    public void resize(int newNumberOfRows) {
        int oldSize = this.m_entries.length;
        if (newNumberOfRows < 0) {
            newNumberOfRows = 0;
        }
        Serializable[][] newEntries = new Serializable[newNumberOfRows][];
        int i = 0;
        while (i < newNumberOfRows && i < oldSize) {
            newEntries[i] = this.m_entries[i];
            ++i;
        }
        if (newNumberOfRows > oldSize) {
            int colCount = this.m_header.length;
            int j = oldSize;
            while (j < newNumberOfRows) {
                newEntries[j] = new Serializable[colCount];
                ++j;
            }
        }
        this.m_entries = newEntries;
        this.internalStateChanged();
    }

    public int getTyp() {
        return 7;
    }

    private void internalStateChanged() {
        this.m_lastChangeDate = System.currentTimeMillis();
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.reportTable(this, this.m_header, this.m_entries);
        }
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + "</attributes>";
        return result;
    }

    protected String buildXmlStructures() {
        String result = "<header>";
        int i = 0;
        while (i < this.m_header.length) {
            result = result + "<col name=\"" + this.m_header[i] + "\"/>";
            ++i;
        }
        result = result + "</header>";
        result = result + "<table>";
        int i2 = 0;
        while (i2 < this.m_entries.length) {
            result = result + "<td>";
            int j = 0;
            while (j < this.m_entries[i2].length) {
                result = result + "<td> " + this.m_entries[i2][j] + "</td>";
                ++j;
            }
            result = result + "</td>";
            ++i2;
        }
        result = result + "</table>";
        return result;
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return "";
        }
        return "No value has been reported yet";
    }
}

