/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.AttributeMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;

public class StringMonitorNode
extends AttributeMonitorNode
implements IStringMonitorNode {
    protected String m_text;

    public StringMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public void setText(String text) {
        this.hasReportedValue = true;
        this.m_text = text;
        this.m_lastChangeDate = System.currentTimeMillis();
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.reportString(this, this.m_text);
        }
    }

    public String getText() {
        return this.m_text;
    }

    public int getTyp() {
        return 6;
    }

    protected String buildXmlStructures() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("text", this.m_text);
        result = result + "</attributes>";
        return result;
    }

    protected String buildXmlAttributes() {
        return " type=\"Text\"  text=\"" + this.m_text + "\"";
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return this.m_text;
        }
        return "No value has been reported yet";
    }
}

