/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.MonitorException;
import com.sap.engine.library.monitor.impl0.CommonStateMonitorNode;

public class StateMonitorNode
extends CommonStateMonitorNode
implements IStateMonitorNode {
    protected String[] m_redStates = new String[0];
    protected String[] m_yellowStates = new String[0];
    protected String[] m_greenStates = new String[0];

    public StateMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public StateMonitorNode(String name, boolean explicitGreen) throws InvalidNameException {
        super(name, explicitGreen);
    }

    public void setRedStates(String[] redStates) {
        this.m_redStates = redStates;
        if (redStates == null) {
            this.m_redStates = new String[0];
        }
    }

    public void setGreenStates(String[] greenStates) {
        this.m_greenStates = greenStates;
        if (greenStates == null) {
            this.m_greenStates = new String[0];
        }
    }

    public void setYellowStates(String[] yellowStates) {
        this.m_yellowStates = yellowStates;
        if (yellowStates == null) {
            this.m_yellowStates = new String[0];
        }
    }

    public String[] getRedStates() {
        return this.m_redStates;
    }

    public String[] getGreenStates() {
        return this.m_greenStates;
    }

    public String[] getYellowStates() {
        return this.m_yellowStates;
    }

    public void setState(String state) throws MonitorException {
        super.setState(state, this.determineColor(state));
    }

    public int getTyp() {
        return 9;
    }

    public int determineColor(String state) {
        if (state == null) {
            return 0;
        }
        int i = 0;
        while (this.m_redStates != null && i < this.m_redStates.length) {
            if (state.equals(this.m_redStates[i])) {
                return 3;
            }
            ++i;
        }
        int i2 = 0;
        while (this.m_yellowStates != null && i2 < this.m_yellowStates.length) {
            if (state.equals(this.m_yellowStates[i2])) {
                return 2;
            }
            ++i2;
        }
        int i3 = 0;
        while (this.m_greenStates != null && i3 < this.m_greenStates.length) {
            if (state.equals(this.m_greenStates[i3])) {
                return 1;
            }
            ++i3;
        }
        return 0;
    }
}

