/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.Util;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class QualityRateMonitorNode
extends PerformanceMonitorNode
implements IQualityRateMonitorNode {
    private static final int PERCENT_MAPPING = 100;
    private long m_totalTries = 0L;
    private long m_successfulTries = 0L;
    private double m_currentQualityRate = 1.0;
    private double m_minQualityRate = 1.0;
    private double m_maxQualityRate;
    private boolean extremaInitiated = false;

    public QualityRateMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("averageQualityRate", this.getAverageQualityRate());
        result = result + AbstractMonitorNode.getAttributeString("averageQualityRate", this.m_currentQualityRate);
        result = result + AbstractMonitorNode.getAttributeString("totalTries", this.m_totalTries);
        result = result + AbstractMonitorNode.getAttributeString("successfulTries", this.m_successfulTries);
        result = result + AbstractMonitorNode.getAttributeString("minQualityRate", this.m_minQualityRate);
        result = result + AbstractMonitorNode.getAttributeString("maxQualityRate", this.m_maxQualityRate);
        result = result + "</attributes>";
        return result;
    }

    protected Serializable getValueForPerformanceHistory() {
        return null;
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    public int getTyp() {
        return 14;
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return new Double(Util.round(this.m_currentQualityRate * 100.0)).toString() + " %";
        }
        return "No value has been reported yet";
    }

    public void addTries(long tries, long successfulTries) {
        this.hasReportedValue = true;
        this.m_totalTries += tries;
        this.m_successfulTries += successfulTries;
        if (successfulTries >= 0L && tries >= successfulTries) {
            this.m_currentQualityRate = successfulTries > 0L ? (double)successfulTries / (double)tries : (tries == 0L ? 1.0 : 0.0);
            double currentQualityRateInPercent = 100.0 * this.m_currentQualityRate;
            this.checkThresholds(currentQualityRateInPercent);
            if (this.isKeepingHistory()) {
                this.history.update(new Double(currentQualityRateInPercent));
            }
            if (this.extremaInitiated) {
                if (this.m_currentQualityRate > this.m_maxQualityRate) {
                    this.m_maxQualityRate = this.m_currentQualityRate;
                }
                if (this.m_currentQualityRate < this.m_minQualityRate) {
                    this.m_minQualityRate = this.m_currentQualityRate;
                }
            } else {
                this.m_maxQualityRate = this.m_minQualityRate = this.m_currentQualityRate;
                this.extremaInitiated = true;
            }
            this.m_lastChangeDate = System.currentTimeMillis();
            CcmsConnector connector = CcmsConnector.getInstance();
            if (connector != null) {
                connector.reportQuality(this, currentQualityRateInPercent);
            }
        }
    }

    public void resetTries(long totalTries, long successfulTries) {
        this.addTries(totalTries - this.m_totalTries, successfulTries - this.m_successfulTries);
    }

    public double getCurrentQualityRate() {
        return this.m_currentQualityRate;
    }

    public double getAverageQualityRate() {
        if (this.m_totalTries == 0L) {
            return 1.0;
        }
        return (double)this.m_successfulTries / (double)this.m_totalTries;
    }

    public long getTotalTries() {
        return this.m_totalTries;
    }

    public long getSuccessfulTries() {
        return this.m_successfulTries;
    }

    public double getMinQualityRate() {
        return this.m_minQualityRate;
    }

    public double getMaxQualityRate() {
        return this.m_maxQualityRate;
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(100.0 * this.m_currentQualityRate);
    }
}

