/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IPoolMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import java.io.Serializable;

public class PoolMonitorNode
extends PerformanceMonitorNode
implements IPoolMonitorNode {
    protected int m_maxPoolSize;
    protected int m_currentPoolSize;
    protected int m_numberOfCurrentUsedObjects;
    protected int m_maxNumberOfCurrentUsedObjects;
    protected int m_minNumberOfCurrentUsedObjects;
    protected int m_minPoolSize;
    protected int m_initialPoolSize;
    protected int m_incrementSize;
    protected double m_currentUsageInPercent;

    public PoolMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public void setMaxPoolSize(int maxSize) {
        this.m_maxPoolSize = maxSize;
        this.m_lastChangeDate = System.currentTimeMillis();
        this.calculateUsage();
    }

    public int getMaxPoolSize() {
        return this.m_maxPoolSize;
    }

    public void setCurrentPoolSize(int size) {
        this.m_currentPoolSize = size;
        this.m_lastChangeDate = System.currentTimeMillis();
    }

    public int getCurrentPoolSize() {
        return this.m_currentPoolSize;
    }

    public void setNumberOfCurrentUsedObjects(int number) {
        this.m_numberOfCurrentUsedObjects = number;
        this.m_lastChangeDate = System.currentTimeMillis();
        this.calculateUsage();
    }

    public int getNumberOfCurrentUsedObjects() {
        return this.m_numberOfCurrentUsedObjects;
    }

    public int getMaxNumberOfCurrentUsedObjects() {
        return this.m_maxNumberOfCurrentUsedObjects;
    }

    public int getMinNumberOfCurrentUsedObjects() {
        return this.m_minNumberOfCurrentUsedObjects;
    }

    public void setMinPoolSize(int minSize) {
        this.m_minPoolSize = minSize;
        this.m_lastChangeDate = System.currentTimeMillis();
    }

    public int getMinPoolSize() {
        return this.m_minPoolSize;
    }

    public void setInitialPoolSize(int initialSize) {
        this.m_initialPoolSize = initialSize;
        this.m_lastChangeDate = System.currentTimeMillis();
    }

    public int getInitialPoolSize() {
        return this.m_initialPoolSize;
    }

    public void setIncrementSize(int incrementSize) {
        this.m_incrementSize = incrementSize;
        this.m_lastChangeDate = System.currentTimeMillis();
    }

    public int getIncrementSize() {
        return this.m_incrementSize;
    }

    public int getTyp() {
        return 8;
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("maxPoolSize", this.m_maxPoolSize);
        result = result + AbstractMonitorNode.getAttributeString("minPoolSize", this.m_minPoolSize);
        result = result + AbstractMonitorNode.getAttributeString("currentPoolSize", this.m_currentPoolSize);
        result = result + AbstractMonitorNode.getAttributeString("numberOfCurrentUsedObjects", this.m_numberOfCurrentUsedObjects);
        result = result + AbstractMonitorNode.getAttributeString("initialPoolSize", this.m_initialPoolSize);
        result = result + AbstractMonitorNode.getAttributeString("incrementSize", this.m_incrementSize);
        result = result + "</attributes>";
        return result;
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    protected void calculateUsage() {
        if (this.m_numberOfCurrentUsedObjects > this.m_maxNumberOfCurrentUsedObjects) {
            this.m_maxNumberOfCurrentUsedObjects = this.m_numberOfCurrentUsedObjects;
        }
        if (this.m_numberOfCurrentUsedObjects < this.m_minNumberOfCurrentUsedObjects) {
            this.m_minNumberOfCurrentUsedObjects = this.m_numberOfCurrentUsedObjects;
        }
        this.m_currentUsageInPercent = this.m_maxPoolSize == 0 ? 0.0 : (double)this.m_numberOfCurrentUsedObjects * 100.0 / (double)this.m_maxPoolSize;
        this.checkThresholds(this.m_currentUsageInPercent);
        if (this.isKeepingHistory()) {
            this.history.update(new Double(this.m_currentUsageInPercent));
        }
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Double(this.m_currentUsageInPercent);
    }

    public String getMostSignificantValueAsString() {
        return new Integer(this.m_currentPoolSize).toString() + this.getUnit();
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_currentUsageInPercent);
    }
}

