/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.history.History;
import com.sap.engine.library.monitor.history.IHistory;
import com.sap.engine.library.monitor.impl0.AttributeMonitorNode;
import com.sap.engine.library.monitor.impl0.MonitorTreeAlertEvent;
import com.sap.engine.library.monitor.impl0.MonitorTreeListenerRegistry;
import java.io.Serializable;

public abstract class PerformanceMonitorNode
extends AttributeMonitorNode
implements IPerformanceMonitorNode {
    private static final int S_INTERVAL_GREEN = 0;
    private static final int S_INTERVAL_GREEN_YELLOW = 1;
    private static final int S_INTERVAL_YELLOW = 2;
    private static final int S_INTERVAL_YELLOW_RED = 3;
    private static final int S_INTERVAL_RED = 4;
    protected IThresholds m_thresholds = null;
    protected boolean m_keepHistory = false;
    protected History history = null;
    protected boolean m_alertOnRed = false;
    private String unit = "";
    private int alertRelevantValueType = 1;

    public PerformanceMonitorNode() {
    }

    public PerformanceMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public void setThresholds(IThresholds thresholds) {
        this.m_thresholds = thresholds;
    }

    public IThresholds getThresholds() {
        return this.m_thresholds;
    }

    public IHistory getHistory() {
        return this.history;
    }

    public void setKeepingHistory(boolean keepHistory, int averagingMode) {
        this.m_keepHistory = keepHistory;
        if (!this.m_keepHistory) {
            this.history = null;
        }
        if (this.m_keepHistory && this.history == null) {
            this.history = new History();
            this.history.setAveragingMode(averagingMode);
        }
    }

    public boolean isKeepingHistory() {
        return this.m_keepHistory;
    }

    public void setAlertOnRed(boolean alert) {
        this.m_alertOnRed = alert;
    }

    public boolean getAlertOnRed() {
        return this.m_alertOnRed;
    }

    public int getAlertRelevantValueType() {
        return this.alertRelevantValueType;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setAlertRelevantValueType(int type) throws IllegalArgumentException {
        if (type != 3 && type != 4 && type != 2 && type != 1 && type != 5 && type != 6) {
            throw new IllegalArgumentException("Unexpected type (" + type + ").");
        }
        this.alertRelevantValueType = type;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? "" : unit;
    }

    protected void checkThresholds(double newValue) {
        if (this.m_thresholds == null) {
            this.m_color = 0;
            return;
        }
        int interval = this.getInterval(newValue);
        int oldColor = this.m_color;
        if (interval == 4) {
            this.m_color = 3;
        } else if (interval == 2) {
            this.m_color = 2;
        } else if (interval == 0) {
            this.m_color = 1;
        } else if (interval == 1) {
            if (this.m_color == 1 || this.m_color == 0) {
                this.m_color = 1;
            }
        } else if (this.m_color == 3 || this.m_color == 0) {
            this.m_color = 3;
        }
        if (oldColor != this.m_color && this.m_color == 3) {
            this.alert();
        }
    }

    private int getInterval(double value) {
        if (this.m_thresholds.getDirection() == 1) {
            if (value < (double)this.m_thresholds.getThresholdFromYellowToGreen()) {
                return 0;
            }
            if (value <= (double)this.m_thresholds.getThresholdFromGreenToYellow()) {
                return 1;
            }
            if (value < (double)this.m_thresholds.getThresholdFromRedToYellow()) {
                return 2;
            }
            if (value <= (double)this.m_thresholds.getThresholdFromYellowToRed()) {
                return 3;
            }
            return 4;
        }
        if (value < (double)this.m_thresholds.getThresholdFromYellowToRed()) {
            return 4;
        }
        if (value <= (double)this.m_thresholds.getThresholdFromRedToYellow()) {
            return 3;
        }
        if (value < (double)this.m_thresholds.getThresholdFromGreenToYellow()) {
            return 2;
        }
        if (value <= (double)this.m_thresholds.getThresholdFromYellowToGreen()) {
            return 1;
        }
        return 0;
    }

    protected void alert(String message) {
        MonitorTreeAlertEvent event = new MonitorTreeAlertEvent(this, message);
        MonitorTreeListenerRegistry.getInstance().processAlert(event);
    }

    protected final String buildXmlStructures() {
        String strue = "\"true\"";
        String sfalse = "\"false\"";
        String result = "<performance-history keepHistory=";
        result = this.m_keepHistory ? result + strue : result + sfalse;
        result = result + ">";
        if (!this.m_keepHistory || this.history != null) {
            // empty if block
        }
        result = result + "</performance-history>";
        return result;
    }

    protected abstract Serializable getValueForPerformanceHistory();

    protected abstract void alert();

    public abstract void setThresholdsAndCheck(IThresholds var1);
}

