/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IPerformanceHistory;
import com.sap.engine.library.monitor.ITimedSerializable;
import com.sap.engine.library.monitor.TimedSerializable;
import java.io.Serializable;

public class PerformanceHistory
implements IPerformanceHistory {
    protected static final long s_minuteInMilliSeconds = 60000L;
    protected static final long s_quarterInMilliSeconds = 900000L;
    protected static final long s_hourInMilliSeconds = 3600000L;
    protected static final int s_minutesToKeep = 30;
    protected static final int s_quartersToKeep = 16;
    protected static final int s_hoursToKeep = 24;
    private Serializable valueOneHourAgo = null;
    private long m_lastActualMinute;
    private long m_lastActualQuarter;
    private long m_lastActualHour;
    protected ITimedSerializable[] m_minutesArray = new TimedSerializable[30];
    protected ITimedSerializable[] m_quartersArray = new TimedSerializable[16];
    protected ITimedSerializable[] m_hoursArray = new TimedSerializable[24];
    protected ITimedSerializable m_lastKnownValue = new TimedSerializable();

    public PerformanceHistory() {
        this.m_lastActualMinute = this.getActualMinute();
        this.m_lastActualQuarter = this.getActualQuarter();
        this.m_lastActualHour = this.getActualHour();
        int i = 0;
        while (i < 30) {
            this.m_minutesArray[i] = new TimedSerializable();
            ++i;
        }
        int i2 = 0;
        while (i2 < 16) {
            this.m_quartersArray[i2] = new TimedSerializable();
            ++i2;
        }
        int i3 = 0;
        while (i3 < 24) {
            this.m_hoursArray[i3] = new TimedSerializable();
            ++i3;
        }
    }

    public final long getActualMinute() {
        return System.currentTimeMillis() / 60000L;
    }

    public final long getActualQuarter() {
        return System.currentTimeMillis() / 900000L;
    }

    public final long getActualHour() {
        return System.currentTimeMillis() / 3600000L;
    }

    public ITimedSerializable[] getMinuteHistory() {
        return this.m_minutesArray;
    }

    public ITimedSerializable[] getQuarterHistory() {
        return this.m_quartersArray;
    }

    public ITimedSerializable[] getHourHistory() {
        return this.m_hoursArray;
    }

    public boolean update(Serializable newValue) {
        boolean updatedQuarters;
        long currentTime = System.currentTimeMillis();
        boolean updatedMinutes = this.updateMinutes(currentTime, newValue);
        if (updatedMinutes && (updatedQuarters = this.updateQuarters(currentTime, newValue))) {
            this.updateHours(currentTime, newValue);
        }
        return updatedMinutes;
    }

    public final boolean needsUpdate() {
        return true;
    }

    public String toXml() {
        String result = "";
        String time = "";
        int i = 1;
        while (i <= 30) {
            time = i + " min";
            result = result + PerformanceHistory.writeXmlValue(time, this.m_minutesArray[i - 1]);
            ++i;
        }
        int i2 = 1;
        while (i2 <= 16) {
            time = i2 + " quarter";
            result = result + PerformanceHistory.writeXmlValue(time, this.m_quartersArray[i2 - 1]);
            ++i2;
        }
        int i3 = 1;
        while (i3 <= 24) {
            time = i3 + " min";
            result = result + PerformanceHistory.writeXmlValue(time, this.m_hoursArray[i3 - 1]);
            ++i3;
        }
        return result;
    }

    private boolean updateMinutes(long currentTime, Serializable newValue) {
        long actualMinute = PerformanceHistory.getActualMinute(currentTime);
        long minutesSinceLastUpdate = actualMinute - this.m_lastActualMinute;
        if (minutesSinceLastUpdate == 0L) {
            return false;
        }
        this.m_lastActualMinute = actualMinute;
        PerformanceHistory.shiftExistingEntries(this.m_minutesArray);
        PerformanceHistory.addNewEntry(this.m_minutesArray, currentTime, newValue);
        return true;
    }

    private boolean updateQuarters(long currentTime, Serializable newValue) {
        long actualQuarter = PerformanceHistory.getActualQuarter(currentTime);
        long quartersSinceLastUpdate = actualQuarter - this.m_lastActualQuarter;
        if (quartersSinceLastUpdate == 0L) {
            return false;
        }
        this.m_lastActualQuarter = actualQuarter;
        PerformanceHistory.shiftExistingEntries(this.m_quartersArray);
        PerformanceHistory.addNewEntry(this.m_quartersArray, currentTime, newValue);
        return true;
    }

    private boolean updateHours(long currentTime, Serializable newValue) {
        long actualHour = PerformanceHistory.getActualHour(currentTime);
        long hoursSinceLastUpdate = actualHour - this.m_lastActualHour;
        if (hoursSinceLastUpdate == 0L) {
            return false;
        }
        this.m_lastActualHour = actualHour;
        PerformanceHistory.shiftExistingEntries(this.m_hoursArray);
        PerformanceHistory.addNewEntry(this.m_hoursArray, currentTime, newValue);
        return true;
    }

    private static void shiftExistingEntries(ITimedSerializable[] array) {
        int i = array.length - 1;
        while (i > 0) {
            array[i] = array[i - 1];
            --i;
        }
    }

    private static void addNewEntry(ITimedSerializable[] array, long currentTime, Serializable newValue) {
        array[0] = new TimedSerializable(currentTime, newValue);
    }

    private static final long getActualMinute(long currentTime) {
        return currentTime / 60000L;
    }

    private static final long getActualQuarter(long currentTime) {
        return currentTime / 900000L;
    }

    private static final long getActualHour(long currentTime) {
        return currentTime / 3600000L;
    }

    private static final String writeXmlValue(String time, Object value) {
        return "<history-value time=\"" + time + "\" value=\"" + value + "\" />";
    }
}

