/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IMonitorTreeAlertEvent;
import com.sap.engine.library.monitor.IMonitorTreeAlertListener;
import com.sap.engine.library.monitor.IMonitorTreeListenerRegistry;
import com.sap.engine.library.monitor.IMonitorTreeStructureChangeEvent;
import com.sap.engine.library.monitor.IMonitorTreeStructureListener;
import java.util.Vector;

public class MonitorTreeListenerRegistry
implements IMonitorTreeListenerRegistry {
    private static MonitorTreeListenerRegistry s_instance = null;
    private Vector m_structureListeners = new Vector();
    private Vector m_alertListeners = new Vector();

    protected MonitorTreeListenerRegistry() {
    }

    public static MonitorTreeListenerRegistry getInstance() {
        if (s_instance == null) {
            MonitorTreeListenerRegistry.createInstance();
        }
        return s_instance;
    }

    protected static synchronized MonitorTreeListenerRegistry createInstance() {
        if (s_instance != null) {
            return s_instance;
        }
        s_instance = new MonitorTreeListenerRegistry();
        return s_instance;
    }

    public static void deleteInstance() {
        s_instance = null;
    }

    public synchronized void registerStructureChangeListener(IMonitorTreeStructureListener listener) {
        this.m_structureListeners.addElement(listener);
    }

    public synchronized void unregisterStructureChangeListener(IMonitorTreeStructureListener listener) {
        this.m_structureListeners.removeElement(listener);
    }

    public synchronized void registerAlertListener(IMonitorTreeAlertListener listener) {
        this.m_alertListeners.addElement(listener);
    }

    public synchronized void unregisterAlertListener(IMonitorTreeAlertListener listener) {
        this.m_alertListeners.removeElement(listener);
    }

    public synchronized void removeAllAlertListeners() {
        this.m_alertListeners = new Vector();
    }

    public void processAlert(IMonitorTreeAlertEvent event) {
        int i = this.m_alertListeners.size() - 1;
        while (i >= 0) {
            ((IMonitorTreeAlertListener)this.m_alertListeners.elementAt(i)).reactOnMonitorTreeAlert(event);
            --i;
        }
    }

    public void processStructureChange(IMonitorTreeStructureChangeEvent event) {
        int i = this.m_structureListeners.size() - 1;
        while (i >= 0) {
            ((IMonitorTreeStructureListener)this.m_structureListeners.elementAt(i)).reactOnMonitorTreeStructureChange(event);
            --i;
        }
    }

    public synchronized void removeStructureChangeListeners() {
        this.m_structureListeners = new Vector();
    }

    public int getNumberOfAlertListeners() {
        return this.m_alertListeners.size();
    }

    public int getNumberOfStructureChangeListeners() {
        return this.m_structureListeners.size();
    }
}

