/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.IBooleanMonitorNode;
import com.sap.engine.library.monitor.ICacheMonitorNode;
import com.sap.engine.library.monitor.ICounterMonitorNode;
import com.sap.engine.library.monitor.IDoubleMonitorNode;
import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IFloatMonitorNode;
import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.ILongMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.IMonitorTreeListenerRegistry;
import com.sap.engine.library.monitor.IPoolMonitorNode;
import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.IVariableStateMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.MonitorException;
import com.sap.engine.library.monitor.NotUniqueNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.AvailabilityMonitorNode;
import com.sap.engine.library.monitor.impl0.BooleanMonitorNode;
import com.sap.engine.library.monitor.impl0.CacheMonitorNode;
import com.sap.engine.library.monitor.impl0.ConfigurationMonitorNode;
import com.sap.engine.library.monitor.impl0.CounterMonitorNode;
import com.sap.engine.library.monitor.impl0.DoubleMonitorNode;
import com.sap.engine.library.monitor.impl0.DurationMonitorNode;
import com.sap.engine.library.monitor.impl0.FloatMonitorNode;
import com.sap.engine.library.monitor.impl0.FrequencyMonitorNode;
import com.sap.engine.library.monitor.impl0.IntegerMonitorNode;
import com.sap.engine.library.monitor.impl0.LongMonitorNode;
import com.sap.engine.library.monitor.impl0.MonitorTreeListenerRegistry;
import com.sap.engine.library.monitor.impl0.ObjectMonitorNode;
import com.sap.engine.library.monitor.impl0.PoolMonitorNode;
import com.sap.engine.library.monitor.impl0.PropertiesMonitorNode;
import com.sap.engine.library.monitor.impl0.QualityRateMonitorNode;
import com.sap.engine.library.monitor.impl0.SimpleMonitorNode;
import com.sap.engine.library.monitor.impl0.StateMonitorNode;
import com.sap.engine.library.monitor.impl0.StringMonitorNode;
import com.sap.engine.library.monitor.impl0.SummaryMonitorNode;
import com.sap.engine.library.monitor.impl0.TableMonitorNode;
import com.sap.engine.library.monitor.impl0.Thresholds;
import com.sap.engine.library.monitor.impl0.VariableStateMonitorNode;
import com.sap.engine.library.monitor.impl0.VersionMonitorNode;
import com.sap.tc.logging.Location;

public class MonitorObjectFactory
implements IMonitorObjectFactory {
    private static Location location = Location.getLocation((String)"com.sap.engine.library.monitor.impl0.MonitorObjectFactory");

    public IMonitorNode getRootNode() {
        return AbstractMonitorNode.getRootInstance();
    }

    public IMonitorNode getKernelRootNode() {
        return AbstractMonitorNode.getRootInstance().subNodeWithName("Kernel");
    }

    public IMonitorNode getServicesRootNode() {
        return AbstractMonitorNode.getRootInstance().subNodeWithName("Services");
    }

    public IMonitorNode getApplicationsRootNode() {
        return AbstractMonitorNode.getRootInstance().subNodeWithName("Applications");
    }

    public IMonitorTreeListenerRegistry getMonitorTreeListenerRegistry() {
        return MonitorTreeListenerRegistry.getInstance();
    }

    public IMonitorNode createSimpleMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            SimpleMonitorNode result = new SimpleMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IMonitorNode createSummaryMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            SummaryMonitorNode result = new SummaryMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IMonitorNode createObjectMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            ObjectMonitorNode result = new ObjectMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IStringMonitorNode createStringMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            StringMonitorNode result = new StringMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IStateMonitorNode createStateMonitorNode(String name, IMonitorNode parent, String[] redStates, String[] yellowStates, String[] greenStates) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            StateMonitorNode result = new StateMonitorNode(name);
            parent.addSubNode(result);
            result.setGreenStates(greenStates);
            result.setRedStates(redStates);
            result.setYellowStates(yellowStates);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IVariableStateMonitorNode createVariableStateMonitorNode(String name, IMonitorNode parent, boolean explicitGreen) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            VariableStateMonitorNode result = new VariableStateMonitorNode(name, explicitGreen);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public ITableMonitorNode createTableMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            TableMonitorNode result = new TableMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IPropertiesMonitorNode createPropertiesMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            PropertiesMonitorNode result = new PropertiesMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IPropertiesMonitorNode createVersionMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            VersionMonitorNode result = new VersionMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IPropertiesMonitorNode createConfigurationMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            ConfigurationMonitorNode result = new ConfigurationMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IBooleanMonitorNode createBooleanMonitorNode(String name, IMonitorNode parent) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            BooleanMonitorNode result = new BooleanMonitorNode(name);
            parent.addSubNode(result);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IAvailabilityMonitorNode createAvailabilityMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            AvailabilityMonitorNode result = new AvailabilityMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IIntegerMonitorNode createIntegerMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            IntegerMonitorNode result = new IntegerMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public ILongMonitorNode createLongMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            LongMonitorNode result = new LongMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IFloatMonitorNode createFloatMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            FloatMonitorNode result = new FloatMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IDoubleMonitorNode createDoubleMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            DoubleMonitorNode result = new DoubleMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public ICounterMonitorNode createCounterMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            CounterMonitorNode result = new CounterMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IFrequencyMonitorNode createFrequencyMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            FrequencyMonitorNode result = new FrequencyMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IQualityRateMonitorNode createQualityRateMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            QualityRateMonitorNode result = new QualityRateMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IDurationMonitorNode createDurationMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            DurationMonitorNode result = new DurationMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public ICacheMonitorNode createCacheMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            CacheMonitorNode result = new CacheMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IPoolMonitorNode createPoolMonitorNode(String name, IMonitorNode parent, IThresholds thresholds) throws InvalidNameException {
        if (this.checkUniquePath(parent, name)) {
            PoolMonitorNode result = new PoolMonitorNode(name);
            parent.addSubNode(result);
            result.setThresholds(thresholds);
            return result;
        }
        throw new NotUniqueNameException();
    }

    public IThresholds createThresholds(int greenToYellow, int yellowToRed, int yellowToGreen, int redToYellow) throws MonitorException {
        return new Thresholds(greenToYellow, yellowToRed, yellowToGreen, redToYellow);
    }

    public IThresholds createThresholds(int greenToYellow, int yellowToRed) throws MonitorException {
        return new Thresholds(greenToYellow, yellowToRed);
    }

    public void uninstallMonitorNode(IMonitorNode node, Boolean isRemovedFromCcmsPersistence) {
        if (node == null) {
            location.warningT("Cannot uninstall monitor node, which is null.");
            return;
        }
        IMonitorNode[] childNodes = node.getSubNodes();
        int i = 0;
        while (i < childNodes.length) {
            this.uninstallMonitorNode(childNodes[i], isRemovedFromCcmsPersistence);
            ++i;
        }
        node.remove(isRemovedFromCcmsPersistence);
    }

    private boolean checkUniquePath(IMonitorNode parentNode, String childName) {
        IMonitorNode[] children = parentNode.getSubNodes();
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals(childName)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

