/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.ILongMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class LongMonitorNode
extends PerformanceMonitorNode
implements ILongMonitorNode {
    protected long m_value;
    protected long m_maxValue;
    protected long m_minValue;

    public LongMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("value", this.m_value);
        result = result + AbstractMonitorNode.getAttributeString("maxValue", this.m_maxValue);
        result = result + AbstractMonitorNode.getAttributeString("minValue", this.m_minValue);
        result = result + "</attributes>";
        return result;
    }

    public void setValue(long value) {
        this.hasReportedValue = true;
        long currentTime = System.currentTimeMillis();
        if (this.m_creationTime == this.m_lastChangeDate) {
            this.m_minValue = value;
            this.m_maxValue = value;
        } else {
            if (this.m_minValue > value) {
                this.m_minValue = value;
            }
            if (this.m_maxValue < value) {
                this.m_maxValue = value;
            }
        }
        this.m_value = value;
        this.checkThresholds(value);
        if (this.isKeepingHistory()) {
            this.history.update(new Double(value));
        }
        this.m_lastChangeDate = currentTime;
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.reportLong(this, value);
        }
    }

    public long getValue() {
        return this.m_value;
    }

    public long getMaxValue() {
        return this.m_maxValue;
    }

    public long getMinValue() {
        return this.m_minValue;
    }

    public int getTyp() {
        return 2;
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Long(this.m_value);
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return new Long(this.m_value).toString() + " " + this.getUnit();
        }
        return "No value has been reported yet";
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_value);
    }
}

