/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.ITimedExtremum;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.TimedExtremum;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class IntegerMonitorNode
extends PerformanceMonitorNode
implements IIntegerMonitorNode {
    protected int m_value;
    protected ITimedExtremum m_maxValue = new TimedExtremum();
    protected ITimedExtremum m_minValue = new TimedExtremum();

    public IntegerMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public int getTyp() {
        return 1;
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("value", this.m_value);
        result = result + AbstractMonitorNode.getAttributeString("maxValue", this.m_maxValue.getExtremum());
        result = result + AbstractMonitorNode.getAttributeString("minValue", this.m_minValue.getExtremum());
        result = result + "</attributes>";
        return result;
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Integer(this.m_value);
    }

    public void setValue(int value) {
        this.hasReportedValue = true;
        long currentTime = System.currentTimeMillis();
        if (this.m_creationTime == this.m_lastChangeDate) {
            this.m_minValue.setExtremum(value);
            this.m_minValue.setTimeStamp(currentTime);
            this.m_maxValue.setExtremum(value);
            this.m_maxValue.setTimeStamp(currentTime);
        } else {
            if (this.m_minValue.getExtremum() > value) {
                this.m_minValue.setExtremum(value);
                this.m_minValue.setTimeStamp(currentTime);
            }
            if (this.m_maxValue.getExtremum() < value) {
                this.m_maxValue.setExtremum(value);
                this.m_maxValue.setTimeStamp(currentTime);
            }
        }
        this.m_value = value;
        this.checkThresholds(value);
        if (this.isKeepingHistory()) {
            this.history.update(new Integer(value));
        }
        this.m_lastChangeDate = currentTime;
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.reportInteger(this, value);
        }
    }

    public int getValue() {
        return this.m_value;
    }

    public ITimedExtremum getMaxValue() {
        return this.m_maxValue;
    }

    public ITimedExtremum getMinValue() {
        return this.m_minValue;
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return new Integer(this.m_value).toString() + " " + this.getUnit();
        }
        return "No value has been reported yet";
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_value);
    }
}

