/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.Util;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class FrequencyMonitorNode
extends PerformanceMonitorNode
implements IFrequencyMonitorNode {
    protected double m_minFrequency = 0.0;
    protected double m_maxFrequency = 0.0;
    protected double m_frequency = 0.0;
    protected int numberOfLastEvents = 0;
    protected int temp = 0;

    public FrequencyMonitorNode() {
    }

    public FrequencyMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("frequency", this.m_frequency);
        result = result + AbstractMonitorNode.getAttributeString("maxFrequency", this.m_maxFrequency);
        result = result + AbstractMonitorNode.getAttributeString("minFrequency", this.m_minFrequency);
        result = result + "</attributes>";
        return result;
    }

    public void reportEvents(int number) {
        CcmsConnector connector;
        this.hasReportedValue = true;
        long currentTime = System.currentTimeMillis();
        long timediff = currentTime - this.m_lastChangeDate;
        int eventsDiff = number - this.numberOfLastEvents;
        this.numberOfLastEvents = number;
        if (eventsDiff <= 0) {
            eventsDiff = 0;
        } else {
            this.m_frequency = (double)eventsDiff / ((double)timediff / 1000.0);
        }
        if (this.m_creationTime == this.m_lastChangeDate) {
            this.m_maxFrequency = this.m_frequency;
            this.m_minFrequency = this.m_frequency;
        }
        if (this.m_frequency > this.m_maxFrequency) {
            this.m_maxFrequency = this.m_frequency;
        }
        if (this.m_frequency < this.m_minFrequency) {
            this.m_minFrequency = this.m_frequency;
        }
        this.m_lastChangeDate = currentTime;
        this.checkThresholds(this.m_frequency);
        if (this.isKeepingHistory()) {
            this.history.update(new Double(this.m_frequency));
        }
        if ((connector = CcmsConnector.getInstance()) != null) {
            connector.reportFrequency(this, this.m_frequency);
        }
    }

    public double getFrequency() {
        return this.m_frequency;
    }

    public double getMaxFreqency() {
        return this.m_maxFrequency;
    }

    public double getMinFrequency() {
        return this.m_minFrequency;
    }

    public int getTyp() {
        return 13;
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Double(this.m_frequency);
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return Util.round(this.m_frequency) + " 1/s";
        }
        return "No value has been reported yet";
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_frequency);
    }
}

