/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.Util;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class DurationMonitorNode
extends PerformanceMonitorNode
implements IDurationMonitorNode {
    private long totalNumber;
    private long totalTime;
    private double currentDuration;

    public DurationMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected String buildXmlAttributes() {
        return "";
    }

    protected Serializable getValueForPerformanceHistory() {
        return null;
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    public int getTyp() {
        return 17;
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return new Double(Util.round(this.currentDuration)).toString() + " " + this.getUnit();
        }
        return "No value has been reported yet";
    }

    public void increment(long incrementalNumber, long incrementalTime) {
        this.hasReportedValue = true;
        if (incrementalNumber >= 0L && incrementalTime >= 0L) {
            this.totalNumber += incrementalNumber;
            this.totalTime += incrementalTime;
            if (incrementalNumber != 0L) {
                this.currentDuration = (double)incrementalTime / (double)incrementalNumber;
                this.checkThresholds(this.currentDuration);
                if (this.isKeepingHistory()) {
                    this.history.update(new Double(this.currentDuration));
                }
            } else {
                this.currentDuration = 0.0;
                if (this.isKeepingHistory()) {
                    this.history.update(new Double(this.currentDuration), 0);
                }
            }
            this.m_lastChangeDate = System.currentTimeMillis();
            CcmsConnector connector = CcmsConnector.getInstance();
            if (connector != null) {
                connector.reportDuration(this, this.currentDuration);
            }
        }
    }

    public void set(long totalNumber, long totalTime) {
        this.increment(totalNumber - this.totalNumber, totalTime - this.totalTime);
    }

    public double getCurrentDuration() {
        return this.currentDuration;
    }

    public double getAverageDuration() {
        return (double)this.totalTime / (double)this.totalNumber;
    }

    public long getTotalNumber() {
        return this.totalNumber;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.currentDuration);
    }
}

