/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IDoubleMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import java.io.Serializable;

public class DoubleMonitorNode
extends PerformanceMonitorNode
implements IDoubleMonitorNode {
    protected double m_value;
    protected double m_maxValue;
    protected double m_minValue;

    public DoubleMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("value", this.m_value);
        result = result + AbstractMonitorNode.getAttributeString("maxValue", this.m_maxValue);
        result = result + AbstractMonitorNode.getAttributeString("minValue", this.m_minValue);
        result = result + "</attributes>";
        return result;
    }

    public void setValue(double value) {
        long currentTime = System.currentTimeMillis();
        if (this.m_creationTime == this.m_lastChangeDate) {
            this.m_minValue = value;
            this.m_maxValue = value;
        } else {
            if (this.m_minValue > value) {
                this.m_minValue = value;
            }
            if (this.m_maxValue < value) {
                this.m_maxValue = value;
            }
        }
        this.m_value = value;
        this.checkThresholds(value);
        if (this.isKeepingHistory()) {
            this.history.update(new Double(value));
        }
        this.m_lastChangeDate = currentTime;
    }

    public double getValue() {
        return this.m_value;
    }

    public double getMaxValue() {
        return this.m_maxValue;
    }

    public double getMinValue() {
        return this.m_minValue;
    }

    public int getTyp() {
        return 3;
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Double(this.m_value);
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_value);
    }
}

