/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.ICounterMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import java.io.Serializable;

public class CounterMonitorNode
extends PerformanceMonitorNode
implements ICounterMonitorNode {
    protected long m_counter;

    public CounterMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("counter", this.m_counter);
        result = result + "</attributes>";
        return result;
    }

    public synchronized void add(long count) {
        this.m_counter += count;
        this.checkThresholds(this.m_counter);
        if (this.isKeepingHistory()) {
            this.history.update(new Long(this.m_counter));
        }
        this.m_lastChangeDate = System.currentTimeMillis();
    }

    public synchronized void reset() {
        this.m_counter = 0L;
        this.m_lastChangeDate = System.currentTimeMillis();
    }

    public long getSum() {
        return this.m_counter;
    }

    public int getTyp() {
        return 12;
    }

    protected void alert() {
        String message = "";
        this.alert(message);
    }

    public void set(long count) {
        this.m_counter = 0L;
        this.add(count);
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Long(this.m_counter);
    }

    public String getMostSignificantValueAsString() {
        return new Long(this.m_counter).toString() + " " + this.getUnit();
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_counter);
    }
}

